/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import java.util.IdentityHashMap;
import java.util.function.Function;
import org.graalvm.nativeimage.Feature;

public final class NativeObjectReplacer
implements Function<Object, Object> {
    private final IdentityHashMap<Class<?>, Object> disallowedClasses = new IdentityHashMap(15);

    NativeObjectReplacer(Feature.DuringSetupAccess access) {
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.impl.ClosureNativePointer"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.impl.ClosureNativePointer$NativeDestructor"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.impl.LibFFILibrary"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.impl.LibFFISignature"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.impl.LibFFISymbol"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.impl.LibFFIType$ArrayType"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.impl.LibFFIType$ClosureType"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.impl.LibFFIType$EnvType"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.impl.LibFFIType$ObjectType"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.impl.LibFFIType$SimpleType"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.impl.LibFFIType$StringType"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.impl.LibFFIType$VoidType"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.impl.NativeAllocation$FreeDestructor"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.impl.NativePointer"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.impl.NativeString"), Boolean.FALSE);
    }

    @Override
    public Object apply(Object obj) {
        if (this.disallowedClasses.containsKey(obj.getClass())) {
            throw new UnsupportedFeatureException(String.format("Native object (%s) stored in pre-initialized context.", obj.getClass().getSimpleName()));
        }
        return obj;
    }
}

