/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManagerAbstract;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class OSBTreeCollectionManagerRemote
extends OSBTreeCollectionManagerAbstract {
    private volatile ThreadLocal<Map<UUID, WeakReference<ORidBag>>> pendingCollections = new PendingCollectionsThreadLocal();

    public OSBTreeCollectionManagerRemote(OStorage storage) {
        super(storage);
    }

    public void onShutdown() {
        this.pendingCollections = null;
        super.onShutdown();
    }

    public void onStartup() {
        super.onStartup();
        if (this.pendingCollections == null) {
            this.pendingCollections = new PendingCollectionsThreadLocal();
        }
    }

    protected OSBTreeBonsai<OIdentifiable, Integer> createEdgeTree(OAtomicOperation atomicOperation, int clusterId) {
        throw new UnsupportedOperationException("Creation of SB-Tree from remote storage is not allowed");
    }

    protected OSBTreeBonsai<OIdentifiable, Integer> loadTree(OBonsaiCollectionPointer collectionPointer) {
        throw new UnsupportedOperationException();
    }

    public UUID listenForChanges(ORidBag collection) {
        UUID id = collection.getTemporaryId();
        if (id == null) {
            id = UUID.randomUUID();
        }
        this.pendingCollections.get().put(id, new WeakReference<ORidBag>(collection));
        return id;
    }

    public void updateCollectionPointer(UUID uuid, OBonsaiCollectionPointer pointer) {
        WeakReference<ORidBag> reference = this.pendingCollections.get().get(uuid);
        if (reference == null) {
            OLogManager.instance().warn((Object)this, "Update of collection pointer is received but collection is not registered", new Object[0]);
            return;
        }
        ORidBag collection = (ORidBag)reference.get();
        if (collection != null) {
            collection.notifySaved(pointer);
        }
    }

    public void clearPendingCollections() {
        this.pendingCollections.get().clear();
    }

    public Map<UUID, OBonsaiCollectionPointer> changedIds() {
        throw new UnsupportedOperationException();
    }

    public void clearChangedIds() {
        throw new UnsupportedOperationException();
    }

    private static class PendingCollectionsThreadLocal
    extends ThreadLocal<Map<UUID, WeakReference<ORidBag>>> {
        private PendingCollectionsThreadLocal() {
        }

        @Override
        protected Map<UUID, WeakReference<ORidBag>> initialValue() {
            return new HashMap<UUID, WeakReference<ORidBag>>();
        }
    }
}

