/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.client.remote.ORemoteConnectionManager;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteNodeSession;
import com.orientechnologies.orient.client.remote.message.OCloseRequest;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class OStorageRemoteSession {
    public boolean commandExecuting = false;
    protected int serverURLIndex = -1;
    protected String connectionUserName = null;
    protected String connectionUserPassword = null;
    protected Map<String, OStorageRemoteNodeSession> sessions = new HashMap<String, OStorageRemoteNodeSession>();
    private Set<OChannelBinary> connections = Collections.newSetFromMap(new WeakHashMap());
    private final int uniqueClientSessionId;
    private boolean closed = true;
    private int stickToSession = 0;
    protected String currentUrl;

    public OStorageRemoteSession(int sessionId) {
        this.uniqueClientSessionId = sessionId;
    }

    public boolean hasConnection(OChannelBinary connection) {
        return this.connections.contains(connection);
    }

    public OStorageRemoteNodeSession getServerSession(String serverURL) {
        return this.sessions.get(serverURL);
    }

    public synchronized OStorageRemoteNodeSession getOrCreateServerSession(String serverURL) {
        OStorageRemoteNodeSession session = this.sessions.get(serverURL);
        if (session == null) {
            session = new OStorageRemoteNodeSession(serverURL, this.uniqueClientSessionId);
            this.sessions.put(serverURL, session);
            this.closed = false;
        }
        return session;
    }

    public void addConnection(OChannelBinary connection) {
        this.connections.add(connection);
    }

    public void close() {
        this.commandExecuting = false;
        this.serverURLIndex = -1;
        this.connections = new HashSet<OChannelBinary>();
        this.sessions = new HashMap<String, OStorageRemoteNodeSession>();
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Integer getSessionId() {
        if (this.sessions.isEmpty()) {
            return -1;
        }
        OStorageRemoteNodeSession curSession = this.sessions.values().iterator().next();
        return curSession.getSessionId();
    }

    public String getServerUrl() {
        if (this.sessions.isEmpty()) {
            return null;
        }
        OStorageRemoteNodeSession curSession = this.sessions.values().iterator().next();
        return curSession.getServerURL();
    }

    public synchronized void removeServerSession(String serverURL) {
        this.sessions.remove(serverURL);
    }

    public synchronized Collection<OStorageRemoteNodeSession> getAllServerSessions() {
        return this.sessions.values();
    }

    public void stickToSession() {
        ++this.stickToSession;
    }

    public void unStickToSession() {
        --this.stickToSession;
    }

    public boolean isStickToSession() {
        return this.stickToSession > 0;
    }

    public void closeAllSessions(ORemoteConnectionManager connectionManager, OContextConfiguration clientConfiguration) {
        for (OStorageRemoteNodeSession nodeSession : this.getAllServerSessions()) {
            OChannelBinaryAsynchClient network = null;
            try {
                network = OStorageRemote.getNetwork(nodeSession.getServerURL(), connectionManager, clientConfiguration);
                OCloseRequest request = new OCloseRequest();
                network.beginRequest(request.getCommand(), this);
                request.write((OChannelDataOutput)network, this);
                network.endRequest();
                connectionManager.release(network);
            }
            catch (OIOException ex) {
                OLogManager.instance().debug((Object)this, "Impossible to comunicate to the server for close: %s", (Throwable)ex, new Object[0]);
                connectionManager.remove(network);
            }
            catch (IOException ex) {
                OLogManager.instance().debug((Object)this, "Impossible to comunicate to the server for close: %s", (Throwable)ex, new Object[0]);
                connectionManager.remove(network);
            }
        }
        this.close();
    }

    public String getDebugLastHost() {
        return this.currentUrl;
    }

    public String getCurrentUrl() {
        return this.currentUrl;
    }
}

