/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.client.remote.OCollectionNetworkSerializer;
import com.orientechnologies.orient.client.remote.message.tx.IndexChange;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37Client;
import com.orientechnologies.orient.core.serialization.serializer.result.binary.OResultSerializerNetwork;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;

public class OMessageHelper {
    public static void writeIdentifiable(OChannelDataOutput channel, OIdentifiable o, ORecordSerializer serializer) throws IOException {
        if (o == null) {
            channel.writeShort((short)-2);
        } else if (o instanceof ORecordId) {
            channel.writeShort((short)-3);
            channel.writeRID((ORID)o);
        } else {
            OMessageHelper.writeRecord(channel, o.getRecord(), serializer);
        }
    }

    public static void writeRecord(OChannelDataOutput channel, ORecord iRecord, ORecordSerializer serializer) throws IOException {
        channel.writeShort((short)0);
        channel.writeByte(ORecordInternal.getRecordType((ORecord)iRecord));
        channel.writeRID(iRecord.getIdentity());
        channel.writeVersion(iRecord.getVersion());
        try {
            byte[] stream = OMessageHelper.getRecordBytes(iRecord, serializer);
            channel.writeBytes(stream);
        }
        catch (Exception e) {
            channel.writeBytes(null);
            String message = "Error on unmarshalling record " + iRecord.getIdentity().toString() + " (" + e + ")";
            throw OException.wrapException((OException)new OSerializationException(message), (Throwable)e);
        }
    }

    public static byte[] getRecordBytes(ORecord iRecord, ORecordSerializer serializer) {
        byte[] stream;
        String dbSerializerName = null;
        if (ODatabaseRecordThreadLocal.instance().getIfDefined() != null) {
            dbSerializerName = ((ODatabaseDocumentInternal)iRecord.getDatabase()).getSerializer().toString();
        }
        if (!(ORecordInternal.getRecordType((ORecord)iRecord) != 100 || dbSerializerName != null && dbSerializerName.equals(serializer.toString()))) {
            ((ODocument)iRecord).deserializeFields(new String[0]);
            stream = serializer.toStream(iRecord);
        } else {
            stream = iRecord.toStream();
        }
        return stream;
    }

    public static Map<UUID, OBonsaiCollectionPointer> readCollectionChanges(OChannelDataInput network) throws IOException {
        HashMap<UUID, OBonsaiCollectionPointer> collectionsUpdates = new HashMap<UUID, OBonsaiCollectionPointer>();
        int count = network.readInt();
        for (int i = 0; i < count; ++i) {
            long mBitsOfId = network.readLong();
            long lBitsOfId = network.readLong();
            OBonsaiCollectionPointer pointer = OCollectionNetworkSerializer.INSTANCE.readCollectionPointer(network);
            collectionsUpdates.put(new UUID(mBitsOfId, lBitsOfId), pointer);
        }
        return collectionsUpdates;
    }

    public static void writeCollectionChanges(OChannelDataOutput channel, Map<UUID, OBonsaiCollectionPointer> changedIds) throws IOException {
        channel.writeInt(changedIds.size());
        for (Map.Entry<UUID, OBonsaiCollectionPointer> entry : changedIds.entrySet()) {
            channel.writeLong(entry.getKey().getMostSignificantBits());
            channel.writeLong(entry.getKey().getLeastSignificantBits());
            OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer(channel, entry.getValue());
        }
    }

    public static void writePhysicalPositions(OChannelDataOutput channel, OPhysicalPosition[] previousPositions) throws IOException {
        if (previousPositions == null) {
            channel.writeInt(0);
        } else {
            channel.writeInt(previousPositions.length);
            for (OPhysicalPosition physicalPosition : previousPositions) {
                channel.writeLong(physicalPosition.clusterPosition);
                channel.writeInt(physicalPosition.recordSize);
                channel.writeVersion(physicalPosition.recordVersion);
            }
        }
    }

    public static OPhysicalPosition[] readPhysicalPositions(OChannelDataInput network) throws IOException {
        OPhysicalPosition[] physicalPositions;
        int positionsCount = network.readInt();
        if (positionsCount == 0) {
            physicalPositions = OCommonConst.EMPTY_PHYSICAL_POSITIONS_ARRAY;
        } else {
            physicalPositions = new OPhysicalPosition[positionsCount];
            for (int i = 0; i < physicalPositions.length; ++i) {
                OPhysicalPosition position = new OPhysicalPosition();
                position.clusterPosition = network.readLong();
                position.recordSize = network.readInt();
                position.recordVersion = network.readVersion();
                physicalPositions[i] = position;
            }
        }
        return physicalPositions;
    }

    public static ORawPair<String[], int[]> readClustersArray(OChannelDataInput network) throws IOException {
        int tot = network.readShort();
        String[] clusterNames = new String[tot];
        int[] clusterIds = new int[tot];
        for (int i = 0; i < tot; ++i) {
            String clusterName = network.readString().toLowerCase(Locale.ENGLISH);
            short clusterId = network.readShort();
            clusterNames[i] = clusterName;
            clusterIds[i] = clusterId;
        }
        return new ORawPair((Object)clusterNames, (Object)clusterIds);
    }

    public static void writeClustersArray(OChannelDataOutput channel, ORawPair<String[], int[]> clusters, int protocolVersion) throws IOException {
        String[] clusterNames = (String[])clusters.first;
        int[] clusterIds = (int[])clusters.second;
        channel.writeShort((short)clusterNames.length);
        for (int i = 0; i < clusterNames.length; ++i) {
            channel.writeString(clusterNames[i]);
            channel.writeShort((short)clusterIds[i]);
        }
    }

    public static void writeTransactionEntry(DataOutput iNetwork, ORecordOperationRequest txEntry) throws IOException {
        iNetwork.writeByte(txEntry.getType());
        iNetwork.writeInt(txEntry.getId().getClusterId());
        iNetwork.writeLong(txEntry.getId().getClusterPosition());
        iNetwork.writeByte(txEntry.getRecordType());
        switch (txEntry.getType()) {
            case 3: {
                byte[] record = txEntry.getRecord();
                iNetwork.writeInt(record.length);
                iNetwork.write(record);
                break;
            }
            case 1: {
                iNetwork.writeInt(txEntry.getVersion());
                byte[] record2 = txEntry.getRecord();
                iNetwork.writeInt(record2.length);
                iNetwork.write(record2);
                iNetwork.writeBoolean(txEntry.isContentChanged());
                break;
            }
            case 2: {
                iNetwork.writeInt(txEntry.getVersion());
            }
        }
    }

    static void writeTransactionEntry(OChannelDataOutput iNetwork, ORecordOperationRequest txEntry, ORecordSerializer serializer) throws IOException {
        iNetwork.writeByte(txEntry.getType());
        iNetwork.writeRID(txEntry.getId());
        iNetwork.writeByte(txEntry.getRecordType());
        switch (txEntry.getType()) {
            case 3: {
                iNetwork.writeBytes(txEntry.getRecord());
                break;
            }
            case 1: {
                iNetwork.writeVersion(txEntry.getVersion());
                iNetwork.writeBytes(txEntry.getRecord());
                iNetwork.writeBoolean(txEntry.isContentChanged());
                break;
            }
            case 2: {
                iNetwork.writeVersion(txEntry.getVersion());
            }
        }
    }

    public static ORecordOperationRequest readTransactionEntry(DataInput iNetwork) throws IOException {
        ORecordOperationRequest result = new ORecordOperationRequest();
        result.setType(iNetwork.readByte());
        int clusterId = iNetwork.readInt();
        long clusterPosition = iNetwork.readLong();
        result.setId((ORID)new ORecordId(clusterId, clusterPosition));
        result.setRecordType(iNetwork.readByte());
        switch (result.getType()) {
            case 3: {
                int length = iNetwork.readInt();
                byte[] record = new byte[length];
                iNetwork.readFully(record);
                result.setRecord(record);
                break;
            }
            case 1: {
                result.setVersion(iNetwork.readInt());
                int length2 = iNetwork.readInt();
                byte[] record2 = new byte[length2];
                iNetwork.readFully(record2);
                result.setRecord(record2);
                result.setContentChanged(iNetwork.readBoolean());
                break;
            }
            case 2: {
                result.setVersion(iNetwork.readInt());
            }
        }
        return result;
    }

    static ORecordOperationRequest readTransactionEntry(OChannelDataInput channel, ORecordSerializer ser) throws IOException {
        ORecordOperationRequest entry = new ORecordOperationRequest();
        entry.setType(channel.readByte());
        entry.setId((ORID)channel.readRID());
        entry.setRecordType(channel.readByte());
        switch (entry.getType()) {
            case 3: {
                entry.setRecord(channel.readBytes());
                break;
            }
            case 1: {
                entry.setVersion(channel.readVersion());
                entry.setRecord(channel.readBytes());
                entry.setContentChanged(channel.readBoolean());
                break;
            }
            case 2: {
                entry.setVersion(channel.readVersion());
                break;
            }
        }
        return entry;
    }

    static void writeTransactionIndexChanges(OChannelDataOutput network, ORecordSerializerNetworkV37 serializer, List<IndexChange> changes) throws IOException {
        network.writeInt(changes.size());
        for (IndexChange indexChange : changes) {
            network.writeString(indexChange.getName());
            network.writeBoolean(indexChange.getKeyChanges().cleared);
            int size = indexChange.getKeyChanges().changesPerKey.size();
            if (indexChange.getKeyChanges().nullKeyChanges != null) {
                ++size;
            }
            network.writeInt(size);
            if (indexChange.getKeyChanges().nullKeyChanges != null) {
                network.writeByte((byte)-1);
                network.writeInt(indexChange.getKeyChanges().nullKeyChanges.entries.size());
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry perKeyChange : indexChange.getKeyChanges().nullKeyChanges.entries) {
                    network.writeInt(perKeyChange.operation.ordinal());
                    network.writeRID(perKeyChange.value.getIdentity());
                }
            }
            for (OTransactionIndexChangesPerKey change : indexChange.getKeyChanges().changesPerKey.values()) {
                OType type = OType.getTypeByValue((Object)change.key);
                byte[] value = serializer.serializeValue(change.key, type);
                network.writeByte((byte)type.getId());
                network.writeBytes(value);
                network.writeInt(change.entries.size());
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry perKeyChange : change.entries) {
                    OTransactionIndexChanges.OPERATION op = perKeyChange.operation;
                    if (op == OTransactionIndexChanges.OPERATION.REMOVE && perKeyChange.value == null) {
                        op = OTransactionIndexChanges.OPERATION.CLEAR;
                    }
                    network.writeInt(op.ordinal());
                    if (op == OTransactionIndexChanges.OPERATION.CLEAR) continue;
                    network.writeRID(perKeyChange.value.getIdentity());
                }
            }
        }
    }

    static List<IndexChange> readTransactionIndexChanges(OChannelDataInput channel, ORecordSerializerNetworkV37 serializer) throws IOException {
        ArrayList<IndexChange> changes = new ArrayList<IndexChange>();
        int val = channel.readInt();
        while (val-- > 0) {
            String indexName = channel.readString();
            boolean cleared = channel.readBoolean();
            OTransactionIndexChanges entry = new OTransactionIndexChanges();
            entry.cleared = cleared;
            int changeCount = channel.readInt();
            TreeMap<Object, OTransactionIndexChangesPerKey> entries = new TreeMap<Object, OTransactionIndexChangesPerKey>();
            while (changeCount-- > 0) {
                Object key;
                byte bt = channel.readByte();
                if (bt == -1) {
                    key = null;
                } else {
                    OType type = OType.getById((byte)bt);
                    key = serializer.deserializeValue(channel.readBytes(), type);
                }
                OTransactionIndexChangesPerKey changesPerKey = new OTransactionIndexChangesPerKey(key);
                int keyChangeCount = channel.readInt();
                while (keyChangeCount-- > 0) {
                    ORecordId id;
                    int op = channel.readInt();
                    OTransactionIndexChanges.OPERATION oper = OTransactionIndexChanges.OPERATION.values()[op];
                    if (oper == OTransactionIndexChanges.OPERATION.CLEAR) {
                        oper = OTransactionIndexChanges.OPERATION.REMOVE;
                        id = null;
                    } else {
                        id = channel.readRID();
                    }
                    changesPerKey.add((OIdentifiable)id, oper);
                }
                if (key == null) {
                    entry.nullKeyChanges = changesPerKey;
                    continue;
                }
                entries.put(changesPerKey.key, changesPerKey);
            }
            entry.changesPerKey = entries;
            changes.add(new IndexChange(indexName, entry));
        }
        return changes;
    }

    public static OIdentifiable readIdentifiable(OChannelDataInput network, ORecordSerializer serializer) throws IOException {
        short classId = network.readShort();
        if (classId == -2) {
            return null;
        }
        if (classId == -3) {
            return network.readRID();
        }
        ORecord record = OMessageHelper.readRecordFromBytes(network, serializer);
        return record;
    }

    private static ORecord readRecordFromBytes(OChannelDataInput network, ORecordSerializer serializer) throws IOException {
        byte rec = network.readByte();
        ORecordId rid = network.readRID();
        int version = network.readVersion();
        byte[] content = network.readBytes();
        ORecord record = Orient.instance().getRecordFactoryManager().newInstance(rec, rid.getClusterId(), ODatabaseRecordThreadLocal.instance().getIfDefined());
        ORecordInternal.setIdentity((ORecord)record, (ORecordId)rid);
        ORecordInternal.setVersion((ORecord)record, (int)version);
        serializer.fromStream(content, record, null);
        ORecordInternal.unsetDirty((ORecord)record);
        return record;
    }

    private static void writeProjection(OResult item, OChannelDataOutput channel) throws IOException {
        channel.writeByte((byte)4);
        OResultSerializerNetwork ser = new OResultSerializerNetwork();
        ser.toStream(item, channel);
    }

    private static void writeBlob(OResult row, OChannelDataOutput channel, ORecordSerializer recordSerializer) throws IOException {
        channel.writeByte((byte)0);
        OMessageHelper.writeIdentifiable(channel, (OIdentifiable)row.getBlob().get(), recordSerializer);
    }

    private static void writeVertex(OResult row, OChannelDataOutput channel, ORecordSerializer recordSerializer) throws IOException {
        channel.writeByte((byte)1);
        OMessageHelper.writeDocument(channel, (ODocument)((OElement)row.getElement().get()).getRecord(), recordSerializer);
    }

    private static void writeElement(OResult row, OChannelDataOutput channel, ORecordSerializer recordSerializer) throws IOException {
        channel.writeByte((byte)3);
        OMessageHelper.writeDocument(channel, (ODocument)((OElement)row.getElement().get()).getRecord(), recordSerializer);
    }

    private static void writeEdge(OResult row, OChannelDataOutput channel, ORecordSerializer recordSerializer) throws IOException {
        channel.writeByte((byte)2);
        OMessageHelper.writeDocument(channel, (ODocument)((OElement)row.getElement().get()).getRecord(), recordSerializer);
    }

    private static void writeDocument(OChannelDataOutput channel, ODocument doc, ORecordSerializer serializer) throws IOException {
        OMessageHelper.writeIdentifiable(channel, (OIdentifiable)doc, serializer);
    }

    public static void writeResult(OResult row, OChannelDataOutput channel, ORecordSerializer recordSerializer) throws IOException {
        if (row.isBlob()) {
            OMessageHelper.writeBlob(row, channel, recordSerializer);
        } else if (row.isVertex()) {
            OMessageHelper.writeVertex(row, channel, recordSerializer);
        } else if (row.isEdge()) {
            OMessageHelper.writeEdge(row, channel, recordSerializer);
        } else if (row.isElement()) {
            OMessageHelper.writeElement(row, channel, recordSerializer);
        } else {
            OMessageHelper.writeProjection(row, channel);
        }
    }

    private static OResultInternal readBlob(OChannelDataInput channel) throws IOException {
        ORecordSerializerNetworkV37 serializer = ORecordSerializerNetworkV37.INSTANCE;
        OResultInternal result = new OResultInternal();
        result.setElement(OMessageHelper.readIdentifiable(channel, (ORecordSerializer)serializer));
        return result;
    }

    public static OResultInternal readResult(OChannelDataInput channel) throws IOException {
        byte type = channel.readByte();
        switch (type) {
            case 0: {
                return OMessageHelper.readBlob(channel);
            }
            case 1: {
                return OMessageHelper.readVertex(channel);
            }
            case 2: {
                return OMessageHelper.readEdge(channel);
            }
            case 3: {
                return OMessageHelper.readElement(channel);
            }
            case 4: {
                return OMessageHelper.readProjection(channel);
            }
        }
        return new OResultInternal();
    }

    private static OResultInternal readElement(OChannelDataInput channel) throws IOException {
        OResultInternal result = new OResultInternal();
        result.setElement((OIdentifiable)OMessageHelper.readDocument(channel));
        return result;
    }

    private static OResultInternal readVertex(OChannelDataInput channel) throws IOException {
        OResultInternal result = new OResultInternal();
        result.setElement((OIdentifiable)OMessageHelper.readDocument(channel));
        return result;
    }

    private static OResultInternal readEdge(OChannelDataInput channel) throws IOException {
        OResultInternal result = new OResultInternal();
        result.setElement((OIdentifiable)OMessageHelper.readDocument(channel));
        return result;
    }

    private static ORecord readDocument(OChannelDataInput channel) throws IOException {
        ORecordSerializerNetworkV37Client serializer = ORecordSerializerNetworkV37Client.INSTANCE;
        ORecord record = (ORecord)OMessageHelper.readIdentifiable(channel, (ORecordSerializer)serializer);
        return record;
    }

    private static OResultInternal readProjection(OChannelDataInput channel) throws IOException {
        OResultSerializerNetwork ser = new OResultSerializerNetwork();
        return ser.fromStream(channel);
    }
}

