/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.constraints;

import com.prowidesoftware.swift.constraints.IbanConstraint;
import com.prowidesoftware.swift.model.IBAN;
import com.prowidesoftware.swift.model.IbanValidationResult;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;

public class IbanValidator
implements ConstraintValidator<IbanConstraint, String> {
    public void initialize(IbanConstraint iban) {
    }

    public boolean isValid(String iban, ConstraintValidatorContext context) {
        if (StringUtils.isBlank((CharSequence)iban)) {
            return true;
        }
        IbanValidationResult result = IBAN.validate(iban);
        if (result == IbanValidationResult.OK) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(result.message()).addConstraintViolation();
        return false;
    }
}

