/*
 * Decompiled with CFR 0.152.
 */
package com.pyx4j.maven.plugin.junction;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;

public class ExecuteJunction {
    private String linkExe;
    private String unlinkExe;
    private String unlinkArg;
    private String linkArg;
    boolean needFixSubst = false;
    boolean isUnix = false;

    ExecuteJunction(List pluginArtifacts) throws MojoFailureException {
        String myos = System.getProperty("os.name");
        if (myos == null) {
            throw new MojoFailureException("Unrecongized OS");
        }
        if ((myos = myos.toLowerCase(Locale.ENGLISH)).startsWith("windows")) {
            if (myos.equals("windows 2000")) {
                this.needFixSubst = true;
            }
            File exec = null;
            Iterator i = pluginArtifacts.iterator();
            while (i.hasNext()) {
                Artifact a = (Artifact)i.next();
                if (!"junction".equals(a.getArtifactId())) continue;
                exec = a.getFile();
                break;
            }
            if (exec == null || !exec.canRead()) {
                throw new MojoFailureException("Can't find junction.exe in plugin dependency");
            }
            this.unlinkExe = this.linkExe = exec.getAbsolutePath();
            this.unlinkArg = "-d";
            this.isUnix = false;
        } else {
            this.linkExe = "ln";
            this.linkArg = "-s";
            this.unlinkExe = "rm";
            this.isUnix = true;
        }
    }

    public String toString() {
        return this.linkExe;
    }

    boolean link(String dst, String src) {
        if (this.isUnix) {
            String tmp = dst;
            dst = src;
            src = tmp;
        }
        if (this.linkArg != null) {
            return this.run(this.linkExe, new String[]{this.linkArg, dst, src});
        }
        return this.run(this.linkExe, new String[]{dst, src});
    }

    boolean unlink(String path) {
        if (this.unlinkArg != null) {
            return this.run(this.unlinkExe, new String[]{this.unlinkArg, path});
        }
        return this.run(this.unlinkExe, new String[]{path});
    }

    private boolean run(String exe, String[] args) {
        String[] cmdarray = new String[args.length + 1];
        cmdarray[0] = exe;
        for (int i = 0; i < args.length; ++i) {
            cmdarray[i + 1] = args[i];
        }
        try {
            Process proc = Runtime.getRuntime().exec(cmdarray, null, new File("."));
            try {
                int exitVal = proc.waitFor();
                return exitVal == 0;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

