/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.core;

import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.step.JavaStepFinder;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.step.client.ScenarioFactory;
import com.qmetry.qaf.automation.step.client.csv.KwdTestFactory;
import com.qmetry.qaf.automation.step.client.excel.ExcelTestFactory;
import com.qmetry.qaf.automation.step.client.text.BDDTestFactory;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.PropertyUtil;
import com.qmetry.qaf.automation.util.StringComparator;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import javax.script.ScriptException;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.hamcrest.Matchers;

public class ConfigurationManager {
    static final Log log = LogFactoryImpl.getLog(ConfigurationManager.class);
    private static final ConfigurationManager INSTANCE = new ConfigurationManager();
    private static InheritableThreadLocal<PropertyUtil> LocalProps = new InheritableThreadLocal<PropertyUtil>(){

        @Override
        protected PropertyUtil initialValue() {
            String[] resources;
            PropertyUtil p = new PropertyUtil(System.getProperty("application.properties.file", "resources/application.properties"));
            p.setProperty("isfw.build.info", ConfigurationManager.getBuildInfo());
            p.setEncoding(p.getString(ApplicationProperties.LOCALE_CHAR_ENCODING.key, "UTF-8"));
            p.setProperty("execution.start.ts", System.currentTimeMillis());
            File prjDir = new File(".").getAbsoluteFile().getParentFile();
            p.setProperty("project.path", prjDir.getAbsolutePath());
            if (!p.containsKey("project.name")) {
                p.setProperty("project.name", prjDir.getName());
            }
            log.info((Object)("ISFW build info: " + p.getProperty("isfw.build.info")));
            String[] stringArray = resources = p.getStringArray("env.resources", "resources");
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                String resource = stringArray[n2];
                ConfigurationManager.addBundle(p, resource);
                ++n2;
            }
            PropertyConfigurationListener cl = new PropertyConfigurationListener();
            p.addConfigurationListener(cl);
            return p;
        }

        @Override
        protected PropertyUtil childValue(PropertyUtil parentValue) {
            PropertyUtil cp = new PropertyUtil(parentValue);
            PropertyConfigurationListener cl = new PropertyConfigurationListener();
            cp.addConfigurationListener(cl);
            return cp;
        }
    };

    private ConfigurationManager() {
        AbstractConfiguration.setDefaultListDelimiter((char)';');
        this.registerLookups();
        this.setHostName();
    }

    private void setHostName() {
        try {
            System.setProperty("host.name", InetAddress.getLocalHost().getHostName());
        }
        catch (Error | Exception throwable) {
            InputStream stream = null;
            Scanner s = null;
            try {
                try {
                    Process proc = Runtime.getRuntime().exec("hostname");
                    stream = proc.getInputStream();
                    if (stream != null) {
                        s = new Scanner(stream);
                        s.useDelimiter("\\A");
                        String val = s.hasNext() ? s.next() : "";
                        stream.close();
                        s.close();
                        System.setProperty("host.name", val);
                    }
                }
                catch (Error | Exception e1) {
                    log.trace((Object)e1);
                    try {
                        if (s != null) {
                            s.close();
                        }
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Exception e2) {
                        log.trace((Object)e2);
                    }
                }
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception e2) {
                    log.trace((Object)e2);
                }
            }
        }
    }

    private void registerLookups() {
        ConfigurationInterpolator.registerGlobalLookup((String)"rnd", (StrLookup)new StrLookup(){

            public String lookup(String var) {
                var = var.replace("<%", "${").replace("%>", "}");
                var = ConfigurationManager.getBundle().getSubstitutor().replace(var);
                return StringUtil.getRandomString(var);
            }
        });
        ConfigurationInterpolator.registerGlobalLookup((String)"expr", (StrLookup)new StrLookup(){

            public String lookup(String var) {
                try {
                    var = var.replace("<%", "${").replace("%>", "}");
                    var = ConfigurationManager.getBundle().getSubstitutor().replace(var);
                    Object res = StringUtil.eval(var);
                    return String.valueOf(res);
                }
                catch (ScriptException e) {
                    throw new RuntimeException("Unable to evaluate expression: " + var, e);
                }
            }
        });
    }

    public static ConfigurationManager getInstance() {
        return INSTANCE;
    }

    public static void addBundle(String fileOrDir) {
        ConfigurationManager.addBundle(ConfigurationManager.getBundle(), fileOrDir);
    }

    private static void addBundle(PropertyUtil p, String fileOrDir) {
        String localResources = p.getString("local.reasources", p.getString("env.local.resources", "resources"));
        fileOrDir = p.getSubstitutor().replace(fileOrDir);
        File resourceFile = new File(fileOrDir);
        String[] locals = p.getStringArray(ApplicationProperties.LOAD_LOCALES.key);
        if (!localResources.equalsIgnoreCase(resourceFile.getAbsolutePath())) {
            p.addProperty("local.reasources", resourceFile.getAbsolutePath());
            if (resourceFile.exists()) {
                if (resourceFile.isDirectory()) {
                    boolean loadSubDirs = p.getBoolean("resources.load.subdirs", true);
                    File[] propFiles = FileUtil.listFilesAsArray(resourceFile, ".properties", StringComparator.Suffix, loadSubDirs);
                    log.info((Object)("Resource dir: " + resourceFile.getAbsolutePath() + ". Found property files to load: " + propFiles.length));
                    File[] locFiles = FileUtil.listFilesAsArray(resourceFile, ".loc", StringComparator.Suffix, loadSubDirs);
                    File[] wscFiles = FileUtil.listFilesAsArray(resourceFile, ".wsc", StringComparator.Suffix, loadSubDirs);
                    PropertyUtil p1 = new PropertyUtil();
                    p1.load(propFiles);
                    p1.load(locFiles);
                    p1.load(wscFiles);
                    p.copy((Configuration)p1);
                    propFiles = FileUtil.listFilesAsArray(resourceFile, ".xml", StringComparator.Suffix, loadSubDirs);
                    log.info((Object)("Resource dir: " + resourceFile.getAbsolutePath() + ". Found property files to load: " + propFiles.length));
                    p1 = new PropertyUtil();
                    p1.load(propFiles);
                    p.copy((Configuration)p1);
                } else {
                    try {
                        if (fileOrDir.endsWith(".properties") || fileOrDir.endsWith(".xml") || fileOrDir.endsWith(".loc") || fileOrDir.endsWith(".wsc")) {
                            p.load(resourceFile);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to load " + resourceFile.getAbsolutePath() + "!"), (Throwable)e);
                    }
                }
                if (locals != null && locals.length > 0 && (locals.length == 1 || StringUtil.isBlank((String)p.getString(ApplicationProperties.DEFAULT_LOCALE.key, "")))) {
                    p.setProperty(ApplicationProperties.DEFAULT_LOCALE.key, locals[0]);
                }
                String[] stringArray = locals;
                int n = locals.length;
                int n2 = 0;
                while (n2 < n) {
                    String local = stringArray[n2];
                    log.info((Object)("loading local: " + local));
                    ConfigurationManager.addLocal(p, local, fileOrDir);
                    ++n2;
                }
            } else {
                log.error((Object)(String.valueOf(resourceFile.getAbsolutePath()) + " not exist!"));
            }
        }
    }

    private static void addLocal(PropertyUtil p, String local, String fileOrDir) {
        String defaultLocal = p.getString(ApplicationProperties.DEFAULT_LOCALE.key, "");
        File resourceFile = new File(fileOrDir);
        boolean loadSubDirs = p.getBoolean("resources.load.subdirs", true);
        if (resourceFile.exists()) {
            PropertyUtil p1 = new PropertyUtil();
            p1.setEncoding(p.getString(ApplicationProperties.LOCALE_CHAR_ENCODING.key, "UTF-8"));
            if (resourceFile.isDirectory()) {
                File[] propFiles = FileUtil.listFilesAsArray(resourceFile, "." + local, StringComparator.Suffix, loadSubDirs);
                p1.load(propFiles);
            } else {
                try {
                    if (fileOrDir.endsWith(local)) {
                        p1.load(fileOrDir);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Unable to load " + resourceFile.getAbsolutePath() + "!"), (Throwable)e);
                }
            }
            if (local.equalsIgnoreCase(defaultLocal)) {
                p.copy((Configuration)p1);
            } else {
                Iterator keyIter = p1.getKeys();
                Configuration localSet = p.subset(local);
                while (keyIter.hasNext()) {
                    String key = (String)keyIter.next();
                    localSet.addProperty(key, p1.getObject(key));
                }
            }
        } else {
            log.error((Object)(String.valueOf(resourceFile.getAbsolutePath()) + " not exist!"));
        }
    }

    public static void addAll(Map<String, ?> props) {
        ConfigurationManager.getBundle().addAll(props);
    }

    public static PropertyUtil getBundle() {
        return (PropertyUtil)((Object)LocalProps.get());
    }

    public static void setBundle(PropertyUtil bundle) {
        LocalProps.set(bundle);
    }

    /*
     * Exception decompiling
     */
    private static Map<String, String> getBuildInfo() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<String, TestStep> getStepMapping() {
        if (!ConfigurationManager.getBundle().containsKey("teststep.mapping")) {
            ConfigurationManager.getBundle().setProperty("teststep.mapping", JavaStepFinder.getAllJavaSteps());
            if (ConfigurationManager.getBundle().containsKey(ApplicationProperties.STEP_PROVIDER_PKG.key)) {
                String[] stringArray = ConfigurationManager.getBundle().getStringArray(ApplicationProperties.STEP_PROVIDER_PKG.key);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String pkg = stringArray[n2];
                    ScenarioFactory[] scenarioFactoryArray = ConfigurationManager.getStepFactories();
                    int n3 = scenarioFactoryArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ScenarioFactory factory = scenarioFactoryArray[n4];
                        factory.process(pkg.replaceAll("\\.", "/"));
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        return (Map)ConfigurationManager.getBundle().getObject("teststep.mapping");
    }

    private static ScenarioFactory[] getStepFactories() {
        return new ScenarioFactory[]{new BDDTestFactory(Arrays.asList("bdl")), new KwdTestFactory(Arrays.asList("kwl")), new ExcelTestFactory()};
    }

    private static class PropertyConfigurationListener
    implements ConfigurationListener {
        String oldValue;

        private PropertyConfigurationListener() {
        }

        public void configurationChanged(ConfigurationEvent event) {
            if ((event.getType() == 2 || event.getType() == 3) && event.isBeforeUpdate()) {
                this.oldValue = String.format("%s", ConfigurationManager.getBundle().getObject(event.getPropertyName()));
            }
            if (!(event.getType() != 1 && event.getType() != 3 || event.isBeforeUpdate())) {
                int n;
                Object[] objectArray;
                String key = event.getPropertyName();
                Object value = event.getPropertyValue();
                if (this.oldValue != null && Matchers.equalTo((Object)this.oldValue).matches(value)) {
                    return;
                }
                if (key.equalsIgnoreCase(ApplicationProperties.DRIVER_NAME.key) || StringMatcher.containsIgnoringCase(".capabilit").match(key) || key.equalsIgnoreCase(ApplicationProperties.REMOTE_SERVER.key) || key.equalsIgnoreCase(ApplicationProperties.REMOTE_PORT.key)) {
                    ((QAFTestBase)TestBaseProvider.instance().get()).tearDown();
                    if (key.equalsIgnoreCase(ApplicationProperties.DRIVER_NAME.key)) {
                        ((QAFTestBase)TestBaseProvider.instance().get()).setDriver((String)value);
                    }
                }
                String[] bundles = null;
                if (key.equalsIgnoreCase("env.resources")) {
                    if (event.getPropertyValue() instanceof ArrayList) {
                        ArrayList bundlesArray = (ArrayList)event.getPropertyValue();
                        bundles = bundlesArray.toArray(new String[bundlesArray.size()]);
                    } else {
                        String resourcesBundle = (String)value;
                        if (StringUtil.isNotBlank((String)resourcesBundle)) {
                            bundles = resourcesBundle.split(String.valueOf(PropertyUtil.getDefaultListDelimiter()));
                        }
                    }
                    if (bundles != null && bundles.length > 0) {
                        objectArray = bundles;
                        n = bundles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object res = objectArray[n2];
                            log.info((Object)("Adding resources from: " + (String)res));
                            ConfigurationManager.addBundle((String)res);
                            ++n2;
                        }
                    }
                }
                if (key.equalsIgnoreCase(ApplicationProperties.DEFAULT_LOCALE.key)) {
                    String[] resources;
                    String[] stringArray = resources = ConfigurationManager.getBundle().getStringArray("env.resources", "resources");
                    int n3 = resources.length;
                    n = 0;
                    while (n < n3) {
                        String resource = stringArray[n];
                        String fileOrDir = ConfigurationManager.getBundle().getSubstitutor().replace(resource);
                        ConfigurationManager.addLocal(ConfigurationManager.getBundle(), (String)event.getPropertyValue(), fileOrDir);
                        ++n;
                    }
                }
                if (key.equalsIgnoreCase(ApplicationProperties.STEP_PROVIDER_PKG.key) && ConfigurationManager.getBundle().containsKey("teststep.mapping")) {
                    ConfigurationManager.getStepMapping().putAll(JavaStepFinder.getAllJavaSteps());
                    objectArray = ConfigurationManager.getStepFactories();
                    n = objectArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        Object factory = objectArray[n4];
                        if (event.getPropertyValue() instanceof ArrayList) {
                            ArrayList bundlesArray = (ArrayList)event.getPropertyValue();
                            bundles = bundlesArray.toArray(new String[bundlesArray.size()]);
                            for (String pkg : bundlesArray) {
                                ((ScenarioFactory)factory).process(pkg.replaceAll("\\.", "/"));
                            }
                        } else {
                            String resourcesBundle = (String)value;
                            if (StringUtil.isNotBlank((String)resourcesBundle)) {
                                ((ScenarioFactory)factory).process(resourcesBundle.replaceAll("\\.", "/"));
                            }
                        }
                        ++n4;
                    }
                }
            }
        }
    }
}

