/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.core;

import com.qmetry.qaf.automation.core.CommandLogFormatter;
import com.qmetry.qaf.automation.core.LoggingBean;
import java.text.MessageFormat;
import java.util.Collection;

public class HtmlCommandLogFormatter
implements CommandLogFormatter {
    private static final String HEADER = "<table style=\"width:100%\"><tbody><tr><td><b>Selenium-Command</b></td><td><b>Parameter-1</b></td><td><b>Parameter-2</b></td><td><b>Res.RC</b></td></tr>";
    private static final String FOOTER = "</tbody></table>";
    private static final String COMMAND_LOG_FORMAT = "<tr><td>{0}</td><td>{1}</td><td>{2}</td><td>{3}</td></tr>";

    @Override
    public String getLog(Collection<LoggingBean> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(HEADER);
        for (LoggingBean b : collection) {
            String param1 = b.getArgs() != null && b.getArgs().length > 0 ? HtmlCommandLogFormatter.quoteHtml(b.getArgs()[0]) : "";
            String param2 = b.getArgs() != null && b.getArgs().length > 1 ? HtmlCommandLogFormatter.quoteHtml(b.getArgs()[1]) : "";
            String result = b.getResult();
            int warningIndex = result == null ? 0 : result.toUpperCase().indexOf("(WARNING");
            sb.append(MessageFormat.format(COMMAND_LOG_FORMAT, b.getCommandName(), param1, param2, warningIndex > 0 ? String.valueOf(result.substring(0, warningIndex)) + "[WARNING(s) retrurned!]" : result));
        }
        sb.append(FOOTER);
        return sb.toString();
    }

    public static final String quoteHtml(String unquoted) {
        String quoted = unquoted == null ? "" : unquoted;
        quoted = quoted.replace("&", "&amp;");
        quoted = quoted.replace("<", "&lt;");
        quoted = quoted.replace(">", "&gt;");
        return quoted;
    }
}

