/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.QAFListener;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.step.BDDStepMatcher;
import com.qmetry.qaf.automation.step.QAFTestStepListener;
import com.qmetry.qaf.automation.step.StepExecutionTracker;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.step.TestStepListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseTestStep
implements TestStep {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected String name;
    protected String description;
    protected transient Object[] actualArgs;
    protected StepExecutionTracker stepExecutionTracker;
    private Set<QAFTestStepListener> stepListeners;
    protected String fileName;
    protected int lineNumber;
    protected int threshold;
    protected Map<String, Object> metaData = new HashMap<String, Object>();
    protected BDDStepMatcher stepMatcher = null;

    public BaseTestStep(String name, String description, Object ... actualArgs) {
        this.name = name;
        this.description = description;
        this.setActualArgs(actualArgs);
        this.stepExecutionTracker = new StepExecutionTracker(this);
        this.initStepListeners();
    }

    protected BaseTestStep() {
        this("", "", new Object[0]);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setActualArgs(Object ... args) {
        if (args != null) {
            this.actualArgs = Arrays.copyOf(args, args.length);
        }
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Object[] getActualArgs() {
        return this.actualArgs;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
    }

    @Override
    public abstract TestStep clone();

    protected abstract Object doExecute();

    @Override
    public Object execute() {
        TestStepListener defaultListener = new TestStepListener();
        this.beforExecute(defaultListener);
        try {
            this.stepExecutionTracker.setStartTime(System.currentTimeMillis());
            Object retval = null;
            if (!ApplicationProperties.DRY_RUN_MODE.getBoolenVal(false)) {
                retval = this.doExecute();
            }
            this.stepExecutionTracker.setResult(retval);
            this.stepExecutionTracker.setEndTime(System.currentTimeMillis());
        }
        catch (Throwable t) {
            this.stepExecutionTracker.setEndTime(System.currentTimeMillis());
            this.stepExecutionTracker.setException(t);
            this.onFailure(defaultListener);
        }
        this.afterExecute(defaultListener);
        if (this.stepExecutionTracker.hasException()) {
            if (this.stepExecutionTracker.getException() instanceof Error) {
                throw (Error)this.stepExecutionTracker.getException();
            }
            throw (RuntimeException)this.stepExecutionTracker.getException();
        }
        return this.stepExecutionTracker.getResult();
    }

    protected void onFailure(TestStepListener defaultListener) {
        for (QAFTestStepListener stepListener : this.stepListeners) {
            stepListener.onFailure(this.stepExecutionTracker);
        }
        if (this.stepExecutionTracker.hasException()) {
            defaultListener.onFailure(this.stepExecutionTracker);
        }
    }

    protected void beforExecute(TestStepListener defaultListener) {
        defaultListener.beforExecute(this.stepExecutionTracker);
        for (QAFTestStepListener stepListener : this.stepListeners) {
            stepListener.beforExecute(this.stepExecutionTracker);
        }
    }

    protected void afterExecute(TestStepListener defaultListener) {
        for (QAFTestStepListener stepListener : this.stepListeners) {
            stepListener.afterExecute(this.stepExecutionTracker);
        }
        defaultListener.afterExecute(this.stepExecutionTracker);
    }

    private void initStepListeners() {
        QAFListener cls;
        String listener;
        String[] listeners;
        this.stepListeners = new LinkedHashSet<QAFTestStepListener>();
        String[] stringArray = listeners = ConfigurationManager.getBundle().getStringArray(ApplicationProperties.TESTSTEP_LISTENERS.key);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            listener = stringArray[n2];
            try {
                cls = (QAFTestStepListener)Class.forName(listener).newInstance();
                this.stepListeners.add((QAFTestStepListener)cls);
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to register class as test step listener:  " + listener), (Throwable)e);
            }
            ++n2;
        }
        stringArray = listeners = ConfigurationManager.getBundle().getStringArray(ApplicationProperties.QAF_LISTENERS.key);
        n = listeners.length;
        n2 = 0;
        while (n2 < n) {
            listener = stringArray[n2];
            try {
                cls = (QAFListener)Class.forName(listener).newInstance();
                if (QAFTestStepListener.class.isAssignableFrom(cls.getClass())) {
                    this.stepListeners.add((QAFTestStepListener)cls);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to register class as test step listener:  " + listener), (Throwable)e);
            }
            ++n2;
        }
    }

    @Override
    public StepExecutionTracker getStepExecutionTracker() {
        return this.stepExecutionTracker;
    }

    public void setStepExecutionTracker(StepExecutionTracker stepExecutionTracker) {
        this.stepExecutionTracker = stepExecutionTracker;
    }

    @Override
    public BDDStepMatcher getStepMatcher() {
        return this.stepMatcher;
    }

    public void setStepMatcher(BDDStepMatcher stepMatcher) {
        this.stepMatcher = stepMatcher;
    }
}

