/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step.client;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.data.MetaDataScanner;
import com.qmetry.qaf.automation.step.client.Scenario;
import com.qmetry.qaf.automation.step.client.ScenarioFileParser;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.testng.ITestContext;
import org.testng.annotations.Factory;

public abstract class ScenarioFactory {
    public static final String GROUPS = "groups";
    protected final Log logger = LogFactoryImpl.getLog(this.getClass());
    private List<Scenario> scenarios = new LinkedList<Scenario>();
    private List<String> fileExtension;
    private List<String> includeGroups = new ArrayList<String>();
    private List<String> excludeGroups = new ArrayList<String>();

    public ScenarioFactory(List<String> list) {
        this.fileExtension = list;
    }

    @Factory
    public Object[] getTestsFromFile(ITestContext context) {
        String sanariosloc;
        if (context != null) {
            this.includeGroups = Arrays.asList(context.getIncludedGroups());
            this.excludeGroups = Arrays.asList(context.getExcludedGroups());
        }
        if (StringUtil.isNotBlank((String)(sanariosloc = MetaDataScanner.getParameter(context, "scenario.file.loc")))) {
            ConfigurationManager.getBundle().setProperty("scenario.file.loc", sanariosloc);
        }
        System.out.printf("include groups %s\n exclude groups: %s Scanarios location: %s \n", this.includeGroups, this.excludeGroups, sanariosloc);
        this.logger.info((Object)("scenario.file.loc" + ConfigurationManager.getBundle().getStringArray("scenario.file.loc", "./scenarios")));
        String[] stringArray = ConfigurationManager.getBundle().getStringArray("scenario.file.loc", "./scenarios");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            this.process(fileName);
            ++n2;
        }
        this.logger.info((Object)("total test found: " + this.scenarios.size()));
        return this.scenarios.toArray(new Object[this.scenarios.size()]);
    }

    protected abstract ScenarioFileParser getParser();

    public void process(String fileName) {
        block6: {
            ScenarioFileParser parser;
            block5: {
                parser = this.getParser();
                parser.setExcludeGroups(this.excludeGroups);
                parser.setIncludeGroups(this.includeGroups);
                File fileOrDir = new File(fileName);
                if (!fileOrDir.isDirectory()) break block5;
                Collection files = FileUtil.listFiles((File)fileOrDir, (String[])this.fileExtension.toArray(new String[0]), (boolean)true);
                for (File scenarioFile : files) {
                    try {
                        parser.parse(scenarioFile.getAbsolutePath(), this.scenarios);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break block6;
            }
            if (!this.fileExtension.contains(FileUtil.getExtention(fileName.toLowerCase()))) break block6;
            try {
                parser.parse(fileName, this.scenarios);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

