/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step.client;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.step.BaseTestStep;
import com.qmetry.qaf.automation.step.JavaStep;
import com.qmetry.qaf.automation.step.QAFTestStep;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.step.client.TestSteps;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class TestStepExporter {
    public static void export(PrintStream stream) {
        ConfigurationManager.getBundle().setProperty("method.recording.mode", true);
        TestSteps steps = new TestSteps();
        Map<String, TestStep> stepMapping = ConfigurationManager.getStepMapping();
        for (String stepName : stepMapping.keySet()) {
            BaseTestStep astep = (BaseTestStep)stepMapping.get(stepName);
            if (!(astep instanceof JavaStep)) continue;
            JavaStep javaStep = (JavaStep)astep;
            if (javaStep.getMethod().isAnnotationPresent(QAFTestStep.class)) {
                try {
                    javaStep.execute();
                }
                catch (Exception exception) {}
            }
            String[] paramNames = ConfigurationManager.getBundle().getStringArray("method.param.names", new String[0]);
            Method method = javaStep.getMethod();
            TestSteps.TestStep step = new TestSteps.TestStep();
            step.setName(stepName);
            step.setDescription(javaStep.getDescription());
            int noOfArgs = method.getParameterTypes().length;
            step.setNoOfaArgs(String.valueOf(noOfArgs));
            step.setReturns(method.getReturnType().getCanonicalName());
            int i = 0;
            while (i < noOfArgs) {
                TestSteps.TestStep.Arg arg = new TestSteps.TestStep.Arg();
                arg.setIndex(String.valueOf(i));
                arg.setType(method.getParameterTypes()[i].getCanonicalName());
                if (paramNames != null && paramNames.length > i) {
                    arg.setName(paramNames[i]);
                }
                step.getArg().add(arg);
                ++i;
            }
            ConfigurationManager.getBundle().clearProperty("method.param.names");
            steps.getTestStep().add(step);
        }
        try {
            try {
                JAXBContext jc = JAXBContext.newInstance((String)"com.qmetry.qaf.automation.step.client");
                Marshaller m = jc.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                m.marshal((Object)steps, (OutputStream)stream);
            }
            catch (JAXBException e) {
                e.printStackTrace();
                stream.close();
            }
        }
        finally {
            stream.close();
        }
    }

    public static void main(String[] args) throws IOException {
        PrintStream printStream;
        if (args.length > 0) {
            File file = new File(args[0]);
            file.createNewFile();
            printStream = new PrintStream(file);
        } else {
            printStream = System.out;
        }
        TestStepExporter.export(printStream);
        System.out.println("Export Completed...");
    }
}

