/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui;

import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.ui.selenium.QAFCommandProcessor;
import com.qmetry.qaf.automation.ui.selenium.SeleniumCommandListener;
import com.qmetry.qaf.automation.ui.selenium.SeleniumCommandTracker;
import com.qmetry.qaf.automation.util.StackTraceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SeleniumCommandLogger
implements SeleniumCommandListener {
    protected ArrayList<LoggingBean> commandLog;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Set<String> excludeCommandsFromLogging;

    public SeleniumCommandLogger(ArrayList<LoggingBean> commandLog) {
        this.commandLog = commandLog;
        this.excludeCommandsFromLogging = new HashSet<String>(Arrays.asList("getHtmlSource", "captureEntirePageScreenshotToString", "executeScript", "screenshot"));
        this.excludeCommandsFromLogging.addAll(Arrays.asList(ApplicationProperties.REPORTER_LOG_EXCLUDE_CMD.getStringVal("").split(",")));
    }

    @Override
    public void afterCommand(QAFCommandProcessor proc, SeleniumCommandTracker commandTracker) {
        String[] args = commandTracker.getArgs();
        LoggingBean bean = new LoggingBean(commandTracker.getCommand(), args, commandTracker.getResult());
        if (args != null && args.length > 0 && !StackTraceUtils.isWaitInvolved() && !this.isCommandExcludedFromLogging(commandTracker.getCommand())) {
            this.commandLog.add(bean);
        }
        this.logger.info((Object)bean.toString());
    }

    @Override
    public void beforeCommand(QAFCommandProcessor proc, SeleniumCommandTracker commandTracker) {
        this.logger.info((Object)new LoggingBean(commandTracker.getCommand(), commandTracker.getArgs(), "").toString());
    }

    public void clear() {
        this.commandLog.clear();
    }

    public List<LoggingBean> getLog() {
        return this.commandLog;
    }

    protected boolean isCommandExcludedFromLogging(String commandName) {
        return this.excludeCommandsFromLogging.contains(commandName);
    }
}

