/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.selenium;

import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.HtmlCheckpointResultFormatter;
import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.ui.selenium.IsSelenium;
import com.qmetry.qaf.automation.ui.selenium.WaitService;
import com.qmetry.qaf.automation.ui.selenium.webdriver.QAFWebDriverBackedSelenium;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.PropertyUtil;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.openqa.selenium.By;
import org.openqa.selenium.remote.ScreenshotException;

public class AssertionService {
    private IsSelenium selenium;
    protected Method method;
    protected StringBuffer verificationErrors = new StringBuffer();
    private boolean alwaysCaptureScreenShot = false;
    private boolean isVerificationFailed = false;
    PropertyUtil seleniumProperties;
    private boolean captureScreenShotOnFailure = false;
    private String screenShotDir;
    private String reportDir;
    protected final Log logger = LogFactoryImpl.getLog(this.getClass());
    protected List<CheckpointResultBean> checkPointResults = new ArrayList<CheckpointResultBean>();
    private String lastCapturedScreenShot;

    protected void setUpAssertionService(IsSelenium selenium) {
        this.setUpAssertionService(selenium, ConfigurationManager.getBundle());
    }

    protected void setUpAssertionService(IsSelenium selenium, PropertyUtil props) {
        this.selenium = selenium;
        this.seleniumProperties = props;
        this.setAlwaysCaptureScreenShot(ApplicationProperties.SUCEESS_SCREENSHOT.getBoolenVal(new boolean[0]));
        this.setScreenShotDir(ApplicationProperties.SCREENSHOT_DIR.getStringVal("./img"));
        this.setReportDir(ApplicationProperties.REPORT_DIR.getStringVal("./"));
    }

    public void setMethod(Method method) {
        this.method = method;
        this.clearVerificationErrors();
        this.claerAssertionsLog();
    }

    protected String getReportDir() {
        return this.reportDir;
    }

    protected void setReportDir(String reportDir) {
        this.reportDir = reportDir;
    }

    public String getLastCapturedScreenShot() {
        if (StringUtil.isBlank((String)this.lastCapturedScreenShot)) {
            return "";
        }
        String dir = ApplicationProperties.SCREENSHOT_RELATIVE_PATH.getStringVal(FileUtil.getReletivePath(ApplicationProperties.REPORT_DIR.getStringVal("./"), ApplicationProperties.SCREENSHOT_DIR.getStringVal("./img/")));
        if (!dir.endsWith("/")) {
            dir = String.valueOf(dir) + "/";
        }
        return String.valueOf(dir) + this.lastCapturedScreenShot;
    }

    public void setLastCapturedScreenShot(String lastCapturedScreenShot) {
        this.lastCapturedScreenShot = lastCapturedScreenShot;
    }

    public void setVerificationFailed(boolean isVerificationFailed) {
        this.isVerificationFailed = isVerificationFailed;
    }

    protected void setScreenShotDir(String screenShotDir) {
        this.screenShotDir = screenShotDir;
        FileUtil.checkCreateDir(screenShotDir);
    }

    public boolean isVerificationFailed() {
        boolean retVal = this.isVerificationFailed;
        this.clearVerificationFailed();
        return retVal;
    }

    protected void setVerificationFailed() {
        this.isVerificationFailed = true;
    }

    protected void clearVerificationFailed() {
        this.isVerificationFailed = false;
    }

    public void checkForVerificationErrors() {
        String verificationErrorString = this.getVerificationErrors();
        if (!"".equals(verificationErrorString)) {
            AssertionService.fail(verificationErrorString);
        }
    }

    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    protected void clearVerificationErrors() {
        this.verificationErrors = new StringBuffer();
    }

    public String getVerificationErrors() {
        String retVal = this.verificationErrors.toString().trim();
        return retVal;
    }

    public String getAssertionsLog() {
        return new HtmlCheckpointResultFormatter().getResults(this.checkPointResults);
    }

    public List<CheckpointResultBean> getCheckPointResults() {
        return this.checkPointResults;
    }

    public void claerAssertionsLog() {
        this.checkPointResults = new ArrayList<CheckpointResultBean>();
    }

    public void assertElementPresent(String elementLocator, String name) {
        String failMsg = MessageFormat.format(ConfigurationManager.getBundle().getString("element.present.fail"), name);
        String successMsg = MessageFormat.format(ConfigurationManager.getBundle().getString("element.present.pass"), name);
        boolean res = false;
        try {
            new WaitService().waitForElementPresent(elementLocator);
            res = true;
        }
        catch (Throwable throwable) {}
        this.assertTrue(res, failMsg, successMsg);
    }

    public void assertElementNotPresent(String elementLocator, String name) {
        String failMsg = MessageFormat.format(ConfigurationManager.getBundle().getString("element.notpresent.fail"), name);
        String successMsg = MessageFormat.format(ConfigurationManager.getBundle().getString("element.notpresent.pass"), name);
        boolean res = true;
        try {
            new WaitService().waitForElementNotPresent(elementLocator);
            res = false;
        }
        catch (Throwable throwable) {}
        this.assertFalse(res, failMsg, successMsg);
    }

    public void assertIsVisible(String elementLocator, String elementName) {
        String failMsg = MessageFormat.format(ConfigurationManager.getBundle().getString("element.visible.fail"), elementName);
        String successMsg = MessageFormat.format(ConfigurationManager.getBundle().getString("element.visible.pass"), elementName);
        boolean res = false;
        try {
            new WaitService().waitForElementVisible(elementLocator);
            res = true;
        }
        catch (Throwable throwable) {}
        this.assertTrue(res, failMsg, successMsg);
    }

    public void assertIsNotVisible(String elementLocator, String elementName) {
        String failMsg = MessageFormat.format(ConfigurationManager.getBundle().getString("element.notvisible.fail"), elementName);
        String successMsg = MessageFormat.format(ConfigurationManager.getBundle().getString("element.notvisible.pass"), elementName);
        boolean res = true;
        try {
            new WaitService().waitForElementInVisible(elementLocator);
            res = false;
        }
        catch (Throwable throwable) {}
        this.assertFalse(res, failMsg, successMsg);
    }

    public void assertIsEditable(String elementLocator, String elementName) {
        String failMsg = MessageFormat.format(ConfigurationManager.getBundle().getString("element.editable.fail", "Expected {0} shoud be editable"), elementName);
        String successMsg = MessageFormat.format(ConfigurationManager.getBundle().getString("element.editable.pass", "Expected {0} shoud be editable"), elementName);
        boolean res = false;
        try {
            new WaitService().waitForElementEditable(elementLocator);
            res = true;
        }
        catch (Throwable throwable) {}
        this.assertTrue(res, failMsg, successMsg);
    }

    public void assertIsNotEditable(String elementLocator, String elementName) {
        String failMsg = MessageFormat.format(ConfigurationManager.getBundle().getString("element.editable.fail", "Expected {0} shoud not be editable"), elementName);
        String successMsg = MessageFormat.format(ConfigurationManager.getBundle().getString("element.editable.pass", "Expected {0} shoud not be editable"), elementName);
        boolean res = false;
        try {
            new WaitService().waitForElementNotEditable(elementLocator);
            res = true;
        }
        catch (Throwable throwable) {}
        this.assertTrue(res, failMsg, successMsg);
    }

    public void assertTrue(boolean b, String message) {
        this.assertTrue(b, message, message);
    }

    public void assertImageLoaded(String imgLoc, String msg) {
        this.assertTrue(Boolean.valueOf(this.selenium.getEval("anImgObj=selenium.browserbot.findElement(\"" + imgLoc + "\");(!anImgObj.complete) ? false : !(typeof anImgObj.naturalWidth != \"undefined\" && anImgObj.naturalWidth == 0);")), String.valueOf(msg) + this.selenium.getEval("selenium.browserbot.findElement(\"" + imgLoc + "\").src"));
    }

    public void assertTrue(boolean b, String failMsg, String successMsg) {
        if (!b) {
            this.addAssertionLog(failMsg, MessageTypes.Fail);
            throw new AssertionError((Object)failMsg);
        }
        this.addAssertionLog(successMsg, MessageTypes.Pass);
    }

    public void assertFalse(boolean b, String message) {
        this.assertFalse(b, message, message);
    }

    public void assertFalse(boolean b, String failMsg, String successMsg) {
        this.assertTrue(!b, failMsg, successMsg);
    }

    public void assertEquals(Object actual, Object expected, String message) {
        String msg = MessageFormat.format(ConfigurationManager.getBundle().getString("equals.common"), message, expected.toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;"), actual.toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
        this.assertTrue(AssertionService.seleniumEquals(expected, actual), msg, msg);
    }

    public void assertNotEquals(Object actual, Object expected, String message) {
        String msg = MessageFormat.format(ConfigurationManager.getBundle().getString("not.equals.common"), message, expected.toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;"), actual.toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
        this.assertFalse(AssertionService.seleniumEquals(expected, actual), msg, msg);
    }

    public void assertIsTextPresent(String text, String message) {
        String failMsg = MessageFormat.format(ConfigurationManager.getBundle().getString("text.present.fail"), message, text);
        String successMsg = MessageFormat.format(ConfigurationManager.getBundle().getString("text.present.pass"), message, text);
        this.assertTrue(this.selenium.isTextPresent(text), failMsg, successMsg);
    }

    public void assertIsTextPresent(String text) {
        this.assertIsTextPresent(text, "");
    }

    public void assertIsTextPresent(String text, String locator, String message) {
        try {
            new WaitService().waitForTextPresent(locator, text);
        }
        catch (Throwable throwable) {}
        this.assertEquals(this.selenium.getText(locator), text, message);
    }

    public void assertNotTextPresent(String text, String locator, String message) {
        try {
            new WaitService().waitForTextNotPresent(locator, text);
        }
        catch (Throwable throwable) {}
        this.assertNotEquals(this.selenium.getText(locator), text, message);
    }

    public void assertIsFiledVlaue(String text, String locator, String name) {
        this.assertEquals(this.selenium.getValue(locator), text, name);
    }

    public void assertIsSelectedLabel(String label, String locator, String name) {
        this.assertEquals(this.selenium.getSelectedLabel(locator), label, name);
    }

    public String getReqResXml() {
        return this.selenium.captureNetworkTraffic("xml");
    }

    public boolean verifyTrue(boolean b, String failMessage, String successMessage) {
        try {
            this.assertTrue(b, failMessage, successMessage);
            return true;
        }
        catch (Error e) {
            this.addVerificationError(e);
            return false;
        }
    }

    public boolean verifyFalse(boolean b, String failMessage, String successMessage) {
        return this.verifyTrue(!b, failMessage, successMessage);
    }

    public boolean verifyEquals(Object actual, Object expected, String message) {
        try {
            this.assertEquals(actual, expected, message);
            return true;
        }
        catch (Error e) {
            this.addVerificationError(e);
            return false;
        }
    }

    public boolean verifyText(String text, String message) {
        try {
            this.assertIsTextPresent(text, message);
            return true;
        }
        catch (Error e) {
            this.addVerificationError(e);
            return false;
        }
    }

    public boolean verifyText(String text, String locator, String message) {
        try {
            this.assertIsTextPresent(text, locator, message);
            return true;
        }
        catch (Error e) {
            this.addVerificationError(e);
            return false;
        }
    }

    public boolean verifyValue(String text, String locator, String message) {
        try {
            this.assertIsFiledVlaue(text, locator, message);
            return true;
        }
        catch (Error e) {
            this.addVerificationError(e);
            return false;
        }
    }

    public boolean verifySelectedLabel(String text, String locator, String message) {
        try {
            this.assertIsSelectedLabel(text, locator, message);
            return true;
        }
        catch (Error e) {
            this.addVerificationError(e);
            return false;
        }
    }

    public boolean verifyIsVisible(String elementLocator, String elementName) {
        try {
            this.assertIsVisible(elementLocator, elementName);
            return true;
        }
        catch (Error e) {
            this.addVerificationError(e);
            return false;
        }
    }

    public boolean verifyIsNotVisible(String elementLocator, String elementName) {
        try {
            if (this.verifyElementPresent(elementLocator, elementName)) {
                this.assertIsNotVisible(elementLocator, elementName);
            }
            return true;
        }
        catch (Error e) {
            this.addVerificationError(e);
            return false;
        }
    }

    public boolean verifyIsEditable(String elementLocator, String elementName) {
        try {
            this.assertIsEditable(elementLocator, elementName);
            return true;
        }
        catch (Error e) {
            this.addVerificationError(e);
            return false;
        }
    }

    public boolean verifyIsNotEditable(String elementLocator, String elementName) {
        try {
            this.assertIsNotEditable(elementLocator, elementName);
            return true;
        }
        catch (Error e) {
            this.addVerificationError(e);
            return false;
        }
    }

    public boolean verifyElementPresent(String elementLocator, String elementName) {
        try {
            this.assertElementPresent(elementLocator, elementName);
            return true;
        }
        catch (Error e) {
            this.addVerificationError(e);
            return false;
        }
    }

    public boolean verifyElementNotPresent(String elementLocator, String elementName) {
        try {
            this.assertElementNotPresent(elementLocator, elementName);
            return true;
        }
        catch (Error e) {
            this.addVerificationError(e);
            return false;
        }
    }

    public boolean verifyImageLoaded(String imgLocator, String msg) {
        try {
            this.assertImageLoaded(imgLocator, msg);
            return true;
        }
        catch (Error e) {
            this.addVerificationError(e);
            return false;
        }
    }

    public static void assertEquals(Object s1, Object s2) {
        if (s1 instanceof String && s2 instanceof String) {
            AssertionService.assertEquals(s1, s2);
        } else if (s1 instanceof String && s2 instanceof String[]) {
            AssertionService.assertEquals(s1, s2);
        } else if (s1 instanceof String && s2 instanceof Number) {
            AssertionService.assertEquals(s1, ((Number)s2).toString());
        } else if (s1 instanceof String[] && s2 instanceof String[]) {
            String[] sa1 = (String[])s1;
            String[] sa2 = (String[])s2;
            if (sa1.length != sa2.length) {
                throw new Error("Expected " + sa1 + " but saw " + sa2);
            }
            int j = 0;
            while (j < sa1.length) {
                AssertionService.assertEquals(sa1[j], sa2[j]);
                ++j;
            }
        }
    }

    public static boolean seleniumEquals(String expectedPattern, String actual) {
        Boolean b;
        if (actual.startsWith("regexp:") || actual.startsWith("regex:") || actual.startsWith("regexpi:") || actual.startsWith("regexi:")) {
            String tmp = actual;
            actual = expectedPattern;
            expectedPattern = tmp;
        }
        if ((b = AssertionService.handleRegex("regexp:", expectedPattern, actual, 0)) != null) {
            return b;
        }
        b = AssertionService.handleRegex("regex:", expectedPattern, actual, 0);
        if (b != null) {
            return b;
        }
        b = AssertionService.handleRegex("regexpi:", expectedPattern, actual, 2);
        if (b != null) {
            return b;
        }
        b = AssertionService.handleRegex("regexi:", expectedPattern, actual, 2);
        if (b != null) {
            return b;
        }
        if (expectedPattern.startsWith("exact:")) {
            String expectedExact = expectedPattern.replaceFirst("exact:", "");
            if (!expectedExact.equals(actual)) {
                System.out.println("expected " + actual + " to match " + expectedPattern);
                return false;
            }
            return true;
        }
        String expectedGlob = expectedPattern.replaceFirst("glob:", "");
        expectedGlob = expectedGlob.replaceAll("([\\]\\[\\\\{\\}$\\(\\)\\|\\^\\+.])", "\\\\$1");
        expectedGlob = expectedGlob.replaceAll("\\*", ".*");
        if (!Pattern.compile(expectedGlob = expectedGlob.replaceAll("\\?", "."), 32).matcher(actual).matches()) {
            System.out.println("expected \"" + actual + "\" to match glob \"" + expectedPattern + "\" (had transformed the glob into regexp \"" + expectedGlob + "\"");
            return false;
        }
        return true;
    }

    private static Boolean handleRegex(String prefix, String expectedPattern, String actual, int flags) {
        if (expectedPattern.startsWith(prefix)) {
            String expectedRegEx = String.valueOf(expectedPattern.replaceFirst(prefix, ".*")) + ".*";
            Pattern p = Pattern.compile(expectedRegEx, flags);
            if (!p.matcher(actual).matches()) {
                System.out.println("expected " + actual + " to match regexp " + expectedPattern);
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return null;
    }

    public static boolean seleniumEquals(Object expected, Object actual) {
        if (expected instanceof String && actual instanceof String) {
            return AssertionService.seleniumEquals((String)expected, (String)actual);
        }
        return expected.equals(actual);
    }

    public static void assertEquals(String[] s1, String[] s2) {
        String comparisonDumpIfNotEqual = AssertionService.verifyEqualsAndReturnComparisonDumpIfNot(s1, s2);
        if (comparisonDumpIfNotEqual != null) {
            throw new AssertionError((Object)comparisonDumpIfNotEqual);
        }
    }

    public void verifyEquals(String[] s1, String[] s2) {
        String comparisonDumpIfNotEqual = AssertionService.verifyEqualsAndReturnComparisonDumpIfNot(s1, s2);
        if (comparisonDumpIfNotEqual != null) {
            this.addAssertionLog(comparisonDumpIfNotEqual, MessageTypes.Fail);
        } else {
            this.addAssertionLog(String.format("Expected %s : Actual %s", Arrays.asList(s1), Arrays.asList(s2)), MessageTypes.Pass);
        }
    }

    private static String verifyEqualsAndReturnComparisonDumpIfNot(String[] s1, String[] s2) {
        boolean misMatch = false;
        if (s1.length != s2.length) {
            misMatch = true;
        }
        int j = 0;
        while (j < s1.length) {
            if (!AssertionService.seleniumEquals(s1[j], s2[j])) {
                misMatch = true;
                break;
            }
            ++j;
        }
        if (misMatch) {
            return "Expected " + AssertionService.stringArrayToString(s1) + " but saw " + AssertionService.stringArrayToString(s2);
        }
        return null;
    }

    private static String stringArrayToString(String[] sa) {
        StringBuffer sb = new StringBuffer("{");
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            sb.append(" ").append("\"").append(element).append("\"");
            ++n2;
        }
        sb.append(" }");
        return sb.toString();
    }

    public static String join(String[] sa, char c) {
        StringBuffer sb = new StringBuffer();
        int j = 0;
        while (j < sa.length) {
            sb.append(sa[j]);
            if (j < sa.length - 1) {
                sb.append(c);
            }
            ++j;
        }
        return sb.toString();
    }

    public void addVerificationError(Throwable e) {
        this.addAssertionLog(e.getMessage(), MessageTypes.Fail);
        this.logger.error((Object)e.getMessage(), e);
    }

    public void addAssertionLogWithScreenShot(String msg, MessageTypes type) {
        this.takeScreenShot();
        this.addAssertionLog(msg, type);
    }

    public void addAssertionLog(String msg, MessageTypes type) {
        CheckpointResultBean bean = new CheckpointResultBean();
        bean.setMessage(msg);
        bean.setType(type);
        boolean added = this.addCheckpoint(bean);
        if (added && StringUtil.isBlank((String)this.getLastCapturedScreenShot()) && (ApplicationProperties.FAILURE_SCREENSHOT.getBoolenVal(true) && type == MessageTypes.Fail || type != MessageTypes.Info && ApplicationProperties.SUCEESS_SCREENSHOT.getBoolenVal(false))) {
            this.takeScreenShot();
        }
        bean.setScreenshot(this.getLastCapturedScreenShot());
        this.setLastCapturedScreenShot("");
        if (type == MessageTypes.Fail) {
            this.verificationErrors.append(msg);
        }
    }

    private boolean hasFailure(List<CheckpointResultBean> subSteps) {
        for (CheckpointResultBean subStep : subSteps) {
            if (!StringMatcher.containsIgnoringCase("fail").match(subStep.getType())) continue;
            return true;
        }
        return false;
    }

    private boolean addCheckpoint(CheckpointResultBean bean) {
        CheckpointResultBean prevCheckpointResultBean;
        int checkPoints = this.checkPointResults.size();
        CheckpointResultBean lastCheckpoint = checkPoints > 1 ? this.checkPointResults.get(checkPoints - 1) : null;
        List<CheckpointResultBean> parent = MessageTypes.TestStep.name().equalsIgnoreCase(bean.getType()) || lastCheckpoint == null || !MessageTypes.TestStep.name().equalsIgnoreCase(lastCheckpoint.getType()) ? this.checkPointResults : lastCheckpoint.getSubCheckPoints();
        CheckpointResultBean checkpointResultBean = prevCheckpointResultBean = !parent.isEmpty() ? parent.get(parent.size() - 1) : null;
        if (prevCheckpointResultBean == null || !prevCheckpointResultBean.equals(bean)) {
            parent.add(bean);
            if (lastCheckpoint != null && MessageTypes.TestStep.name().equalsIgnoreCase(lastCheckpoint.getType())) {
                lastCheckpoint.setType(this.hasFailure(lastCheckpoint.getSubCheckPoints()) ? MessageTypes.TestStepFail : MessageTypes.TestStepPass);
            }
            return true;
        }
        return false;
    }

    protected boolean isCaptureScreenShotOnFailure() {
        return this.captureScreenShotOnFailure;
    }

    protected void setCaptureScreenShotOnFailure(boolean captureScreetShotOnFailure) {
        this.captureScreenShotOnFailure = captureScreetShotOnFailure;
    }

    protected boolean isAlwaysCaptureScreenShot() {
        return this.alwaysCaptureScreenShot;
    }

    public void setAlwaysCaptureScreenShot(boolean alwaysCaptureScreenShot) {
        this.alwaysCaptureScreenShot = alwaysCaptureScreenShot;
    }

    private String base64ImageToFile(String base64Image) {
        String filename = "";
        try {
            this.lastCapturedScreenShot = filename = FileUtil.saveImageFile(base64Image, this.getTestCaseName(), this.getScreenShotDir());
            this.logger.info((Object)("Capturing screen shot" + this.lastCapturedScreenShot));
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in capturing screenshot\n" + e.getMessage()));
        }
        return filename;
    }

    public String getLastCapturedScreenShotFile() {
        return this.lastCapturedScreenShot;
    }

    private String captureScreenShot() {
        String filename = String.valueOf(StringUtil.createRandomString(this.getTestCaseName())) + ".png";
        try {
            this.selenium.captureEntirePageScreenshot(String.valueOf(this.getScreenShotDir()) + filename, "");
        }
        catch (Exception exception) {
            try {
                this.selenium.windowFocus();
            }
            catch (Throwable t) {
                this.logger.error((Object)t);
            }
            this.selenium.captureScreenshot(String.valueOf(this.getScreenShotDir()) + filename);
        }
        this.lastCapturedScreenShot = filename;
        this.logger.info((Object)("Captured screen shot: " + this.lastCapturedScreenShot));
        return filename;
    }

    private String captureScreenShot_remote() {
        String base64Image;
        String filename = "";
        try {
            base64Image = this.selenium.captureEntirePageScreenshotToString(ConfigurationManager.getBundle().getString("selenium.screenshots.kwargs", ""));
        }
        catch (Exception exception) {
            try {
                this.selenium.windowFocus();
            }
            catch (Throwable t) {
                this.logger.error((Object)t);
            }
            base64Image = this.selenium.captureScreenshotToString();
        }
        filename = this.base64ImageToFile(base64Image);
        return filename;
    }

    public String takeScreenShot() {
        try {
            this.lastCapturedScreenShot = this.captureScreenShot_remote();
            return this.lastCapturedScreenShot;
        }
        catch (Throwable th) {
            if (th.getMessage() != null && th.getMessage().indexOf("WebDriver") >= 0) {
                String base64Image = "";
                try {
                    if (th.getCause() instanceof ScreenshotException) {
                        throw th;
                    }
                    QAFExtendedWebDriver driver = ((QAFWebDriverBackedSelenium)this.selenium).getWrappedDriver();
                    driver.findElement(By.name((String)"current screen shot")).sendKeys(new CharSequence[]{"capture"});
                    this.logger.info((Object)("Unable to capture ScreenShot: " + th.getMessage()));
                    return "";
                }
                catch (Throwable t) {
                    Throwable cause = t.getCause();
                    if (cause instanceof ScreenshotException) {
                        base64Image = ((ScreenshotException)cause).getBase64EncodedScreenshot();
                        this.lastCapturedScreenShot = this.base64ImageToFile(base64Image);
                        return this.lastCapturedScreenShot;
                    }
                    System.out.println("Unable to retrive capture ScreenShot: " + t.getMessage());
                }
            } else {
                try {
                    this.lastCapturedScreenShot = this.captureScreenShot();
                    return this.lastCapturedScreenShot;
                }
                catch (Throwable t) {
                    this.logger.info((Object)("Unable to capture ScreenShot: " + th.getMessage() + "\n" + t.getMessage()));
                }
            }
            return "";
        }
    }

    protected String getScreenShotDir() {
        return this.screenShotDir;
    }

    protected String getTestCaseName() {
        if (this.method == null) {
            return "SeleneseTest";
        }
        return this.method.getName();
    }
}

