/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.selenium;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.util.JSONUtil;
import org.json.JSONException;

public class SeleniumCommandTracker {
    RuntimeException exception;
    String command;
    String[] args;
    String result;

    public SeleniumCommandTracker(String command, String[] args) {
        this.command = command;
        this.setArgs(args);
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
        if (args != null && args.length > 0) {
            String[] parts;
            String loc = ConfigurationManager.getBundle().getSubstitutor().replace(args[0]);
            if (JSONUtil.isValidJsonString(loc)) {
                try {
                    loc = (String)JSONUtil.toMap(loc).get("locator");
                }
                catch (JSONException jSONException) {
                    throw new RuntimeException("Unable to get locator from " + loc);
                }
            }
            if (loc.indexOf("=") > 0 && ((parts = loc.split("=", 2))[0].equalsIgnoreCase("key") || parts[0].equalsIgnoreCase("property"))) {
                loc = ConfigurationManager.getBundle().getString(parts[1]);
            }
            this.args[0] = loc;
        }
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setException(RuntimeException exception) {
        this.exception = exception;
    }

    public RuntimeException getException() {
        return this.exception;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public Class<? extends RuntimeException> getExceptionType() {
        return this.exception == null ? null : this.exception.getClass();
    }

    public String getMessage() {
        return this.exception == null ? "" : this.exception.getMessage();
    }
}

