/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.selenium.customcommands;

import com.qmetry.qaf.automation.ui.selenium.QAFCustomCommand;
import com.qmetry.qaf.automation.ui.selenium.SeleniumCommandProcessor;
import org.apache.commons.lang.StringUtils;

public class SetAttributeCommand
implements QAFCustomCommand {
    @Override
    public String doCommand(SeleniumCommandProcessor commandProcessor, String ... args) {
        int atSign = args[0].lastIndexOf("@");
        String elementLocator = args[0].substring(0, atSign).trim();
        String attributeName = args[0].substring(atSign + 1).trim();
        String value = args[1];
        if (!(StringUtils.isNumeric((String)value) || "true".equals(value) || "false".equals(value) || value.startsWith("'") || value.startsWith("\""))) {
            value = "\"" + value + "\"";
        }
        String snippet = "";
        try {
            snippet = String.format("selenium.page().findElement(\"%s\").setAttribute('%s',%s);", elementLocator, attributeName, value);
        }
        catch (Exception exception) {
            snippet = attributeName.equalsIgnoreCase("style") ? String.format("selenium.page().findElement(\"%s\").style.setAttribute('cssText',%s);", elementLocator, value) : (attributeName.equalsIgnoreCase("class") ? String.format("selenium.page().findElement(\"%s\").className=%s);", elementLocator, value) : String.format("selenium.page().findElement(\"%s\").%s=%s;", elementLocator, attributeName, value));
        }
        return commandProcessor.doDefaultDoCommand("getEval", new String[]{snippet, ""});
    }

    @Override
    public String getCommandName() {
        return "setAttribute";
    }
}

