/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.webdriver;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.data.MetaDataScanner;
import com.qmetry.qaf.automation.ui.AbstractTestPage;
import com.qmetry.qaf.automation.ui.WebDriverTestBase;
import com.qmetry.qaf.automation.ui.annotations.FindBy;
import com.qmetry.qaf.automation.ui.webdriver.ComponentFactory;
import com.qmetry.qaf.automation.ui.webdriver.ComponentListHandler;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebElement;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebElementListHandler;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebComponent;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebElement;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.Annotations;

public class ElementFactory {
    private static final Log logger = LogFactory.getLog(ElementFactory.class);
    private SearchContext context;

    public ElementFactory() {
        this.context = new WebDriverTestBase().getDriver();
    }

    public ElementFactory(SearchContext context) {
        this.context = context;
    }

    public void initFields(Object classObj) {
        Field[] flds;
        Field[] fieldArray = flds = ClassUtil.getAllFields(classObj.getClass(), AbstractTestPage.class);
        int n = flds.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                field.setAccessible(true);
                if (this.isDecoratable(field)) {
                    Object value = null;
                    if (this.hasAnnotation(field, org.openqa.selenium.support.FindBy.class, FindBys.class)) {
                        Annotations annotations = new Annotations(field);
                        boolean cacheElement = annotations.isLookupCached();
                        By by = annotations.buildBy();
                        if (List.class.isAssignableFrom(field.getType())) {
                            value = this.initList(by, this.context);
                        } else {
                            value = this.context instanceof WebElement ? new QAFExtendedWebElement((QAFExtendedWebElement)this.context, by) : new QAFExtendedWebElement((QAFExtendedWebDriver)this.context, by, cacheElement);
                            this.initMetadata(classObj, field, (QAFExtendedWebElement)value);
                        }
                    } else {
                        FindBy findBy = field.getAnnotation(FindBy.class);
                        if (List.class.isAssignableFrom(field.getType())) {
                            value = this.initList(field, findBy.locator(), this.context, classObj);
                        } else {
                            if (QAFWebComponent.class.isAssignableFrom(field.getType())) {
                                value = ComponentFactory.getObject(field.getType(), findBy.locator(), classObj, this.context);
                            } else {
                                value = ElementFactory.$(findBy.locator());
                                if (this.context instanceof QAFExtendedWebElement) {
                                    ((QAFExtendedWebElement)value).parentElement = (QAFExtendedWebElement)this.context;
                                }
                            }
                            this.initMetadata(classObj, field, (QAFExtendedWebElement)value);
                        }
                    }
                    field.set(classObj, value);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            ++n2;
        }
    }

    private void initMetadata(Object classObj, Field field, QAFExtendedWebElement value) {
        if (value == null) {
            return;
        }
        value.getMetaData().put("pageClass", classObj.getClass());
        value.getMetaData().put("objectName", field.getName());
        value.getMetaData().putAll(MetaDataScanner.getMetadata(field));
    }

    private boolean hasAnnotation(Field field, Class<? extends Annotation> ... classes) {
        Class<? extends Annotation>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Annotation> cls = classArray[n2];
            if (field.isAnnotationPresent(cls)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isDecoratable(Field field) {
        if (!this.hasAnnotation(field, FindBy.class, org.openqa.selenium.support.FindBy.class, FindBys.class)) {
            return false;
        }
        if (WebElement.class.isAssignableFrom(field.getType())) {
            return true;
        }
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
        return WebElement.class.isAssignableFrom((Class)listType);
    }

    private Class<?> getListType(Field field) {
        Type genericType = field.getGenericType();
        Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
        return (Class)listType;
    }

    private Object initList(By by, SearchContext context) throws Exception {
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{List.class}, (InvocationHandler)new QAFExtendedWebElementListHandler(context, by));
    }

    private Object initList(Field field, String loc, SearchContext context, Object clsObject) throws Exception {
        loc = ConfigurationManager.getBundle().getString(loc, loc);
        Class<?> cls = this.getListType(field);
        ComponentListHandler iHandler = QAFWebComponent.class.isAssignableFrom(cls) ? new ComponentListHandler(context, loc, cls, clsObject) : new ComponentListHandler(context, loc, ElementFactory.getElemenetClass(), clsObject);
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{List.class}, (InvocationHandler)iHandler);
    }

    public static QAFWebElement $(String loc) {
        String compClass;
        QAFExtendedWebElement eleToReturn = new QAFExtendedWebElement(loc);
        String string = compClass = eleToReturn.getMetaData().containsKey("component-class") ? (String)eleToReturn.getMetaData().get("component-class") : ConfigurationManager.getBundle().getString("default.element.impl");
        if (StringUtil.isNotBlank((String)compClass)) {
            try {
                return (QAFWebElement)ComponentFactory.getObject(Class.forName(compClass), loc, null);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return eleToReturn;
    }

    public static Class<? extends QAFExtendedWebElement> getElemenetClass() {
        try {
            Class<?> cls = Class.forName(ConfigurationManager.getBundle().getString("default.element.impl", QAFExtendedWebElement.class.getCanonicalName()));
            return cls;
        }
        catch (Exception exception) {
            return QAFExtendedWebElement.class;
        }
    }
}

