/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.util.PropertyUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DatabaseUtil {
    public static final String DB_CONNECTION_URL = "db.connection.url";
    public static final String DB_DRIVER_CLASS = "db.driver.class";
    public static final String DB_USER = "db.user";
    public static final String DB_PWD = "db.pwd";
    private static Logger log = Logger.getLogger(DatabaseUtil.class);

    public static void close(PreparedStatement ps) {
        try {
            if (ps != null) {
                ps.clearWarnings();
                ps.clearParameters();
                ps.close();
            }
        }
        catch (SQLException sqle) {
            log.error((Object)"An error occurred while attempting to close a PreparedStatement", (Throwable)sqle);
        }
    }

    public static void close(Statement s) {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (SQLException sqle) {
            log.error((Object)"An error occurred while attempting to close a SQLStatement", (Throwable)sqle);
        }
    }

    public static void close(PreparedStatement ps, ResultSet rs) {
        DatabaseUtil.close(rs);
        DatabaseUtil.close(ps);
    }

    public static void close(Statement st, ResultSet rs) {
        DatabaseUtil.close(rs);
        DatabaseUtil.close(st);
    }

    public static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sqle) {
            log.error((Object)"An error occurred while attempting to close a ResultSet", (Throwable)sqle);
        }
    }

    public static void close(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException se) {
            log.error((Object)"An error occurred while attempting to close a database connection", (Throwable)se);
        }
    }

    public static Connection getConnection() throws Exception {
        return DatabaseUtil.getConnection("");
    }

    public static Connection getConnection(String prefix) throws Exception {
        PropertyUtil props = StringUtil.isBlank((String)prefix) ? ConfigurationManager.getBundle() : ConfigurationManager.getBundle().subset(prefix);
        String url = props.getString(DB_CONNECTION_URL);
        String driverclass = props.getString(DB_DRIVER_CLASS);
        String user = props.getString(DB_USER);
        String pwd = props.getString(DB_PWD);
        return DatabaseUtil.getConnection(driverclass, url, user, pwd);
    }

    public static Connection getConnection(String driverCls, String url, String user, String pwd) throws Exception {
        Connection con = null;
        Class.forName(driverCls);
        con = DriverManager.getConnection(url, user, pwd);
        return con;
    }

    public static Object[][] getData(String query) {
        ArrayList<Object[]> rows;
        block7: {
            rows = new ArrayList<Object[]>();
            Connection con = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    con = DatabaseUtil.getConnection();
                    stmt = con.createStatement();
                    rs = stmt.executeQuery(query);
                    while (rs.next()) {
                        int colsCnt = rs.getMetaData().getColumnCount();
                        Object[] cols = new Object[colsCnt];
                        int indx = 0;
                        while (indx < colsCnt) {
                            cols[indx] = DatabaseUtil.getValue(rs, indx + 1);
                            ++indx;
                        }
                        rows.add(cols);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DatabaseUtil.close(stmt, rs);
                    DatabaseUtil.close(con);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.close(stmt, rs);
                DatabaseUtil.close(con);
                throw throwable;
            }
            DatabaseUtil.close(stmt, rs);
            DatabaseUtil.close(con);
        }
        return (Object[][])rows.toArray((T[])new Object[0][]);
    }

    public static Object[][] getRecordDataAsMap(String query) {
        ArrayList<Object[]> rows;
        block7: {
            rows = new ArrayList<Object[]>();
            Connection con = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    con = DatabaseUtil.getConnection();
                    stmt = con.createStatement();
                    rs = stmt.executeQuery(query);
                    while (rs.next()) {
                        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                        int colsCnt = rs.getMetaData().getColumnCount();
                        int indx = 1;
                        while (indx <= colsCnt) {
                            map.put(rs.getMetaData().getColumnLabel(indx), DatabaseUtil.getValue(rs, indx));
                            ++indx;
                        }
                        rows.add(new Object[]{map});
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DatabaseUtil.close(stmt, rs);
                    DatabaseUtil.close(con);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.close(stmt, rs);
                DatabaseUtil.close(con);
                throw throwable;
            }
            DatabaseUtil.close(stmt, rs);
            DatabaseUtil.close(con);
        }
        return (Object[][])rows.toArray((T[])new Object[0][]);
    }

    public static List<Map<String, Object>> getRecordAsMap(String query) {
        return DatabaseUtil.getRecordAsMap("", query);
    }

    public static List<Map<String, Object>> getRecordAsMap(String connectionPrefix, String query) {
        ArrayList<Map<String, Object>> rows;
        block7: {
            rows = new ArrayList<Map<String, Object>>();
            Connection con = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    con = DatabaseUtil.getConnection(connectionPrefix);
                    stmt = con.createStatement();
                    rs = stmt.executeQuery(query);
                    while (rs.next()) {
                        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
                        int colsCnt = rs.getMetaData().getColumnCount();
                        int indx = 1;
                        while (indx <= colsCnt) {
                            map.put(rs.getMetaData().getColumnLabel(indx), DatabaseUtil.getValue(rs, indx));
                            ++indx;
                        }
                        rows.add(map);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DatabaseUtil.close(stmt, rs);
                    DatabaseUtil.close(con);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.close(stmt, rs);
                DatabaseUtil.close(con);
                throw throwable;
            }
            DatabaseUtil.close(stmt, rs);
            DatabaseUtil.close(con);
        }
        return rows;
    }

    private static Object getValue(ResultSet rs, int colIndex) throws SQLException {
        Object oVal = rs.getObject(colIndex);
        try {
            if (oVal instanceof Blob) {
                oVal = rs.getBytes(colIndex);
            } else if (oVal instanceof Clob) {
                oVal = rs.getString(colIndex);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        return oVal;
    }
}

