/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.testng.DataProviderException;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.File;
import java.util.LinkedHashMap;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

public class ExcelUtil {
    private static final Log logger = LogFactoryImpl.getLog(ExcelUtil.class);

    private static int getFirstRow(Sheet s, boolean skipHeaderRow) {
        int row = 0;
        int l = s.getRows();
        row = 0;
        while (row < l) {
            Cell[] cells = s.getRow(row);
            boolean isEmptyRow = true;
            Cell[] cellArray = cells;
            int n = cells.length;
            int n2 = 0;
            while (n2 < n) {
                Cell cell = cellArray[n2];
                if (StringUtil.isNotBlank((String)cell.getContents())) {
                    isEmptyRow = false;
                    break;
                }
                ++n2;
            }
            if (!isEmptyRow) {
                if (!skipHeaderRow) break;
                skipHeaderRow = false;
            }
            ++row;
        }
        return row;
    }

    private static int getFirstCol(Sheet s) {
        int l = s.getColumns();
        Cell[] cells = s.getRow(ExcelUtil.getFirstRow(s, false));
        int col = 0;
        while (col < l) {
            Cell cell = cells[col];
            if (StringUtils.isNotBlank((String)cell.getContents())) {
                return col;
            }
            ++col;
        }
        return 0;
    }

    public static Object[][] getExcelData(String file, boolean headerRow, String sheetName) {
        File f;
        Workbook workbook;
        Object[][] retobj;
        block14: {
            retobj = null;
            workbook = null;
            f = new File(file);
            if (f.exists() && f.canRead()) break block14;
            logger.error((Object)(" Can not read file " + f.getAbsolutePath() + " Returning empty dataset1"));
            Object[][] objectArray = new Object[][]{};
            try {
                workbook.close();
            }
            catch (Exception exception) {}
            return objectArray;
        }
        try {
            try {
                Sheet sheet;
                workbook = Workbook.getWorkbook((File)f);
                Sheet sheet2 = sheet = StringUtils.isNotBlank((String)sheetName) ? workbook.getSheet(sheetName) : workbook.getSheet(0);
                if (sheet == null) {
                    throw new RuntimeException("Worksheet " + sheetName + " not found in " + f.getAbsolutePath());
                }
                int firstRow = ExcelUtil.getFirstRow(sheet, headerRow);
                int firstCol = ExcelUtil.getFirstCol(sheet);
                int lastRow = sheet.getRows();
                int colsCnt = sheet.getColumns();
                logger.info((Object)("Rows : " + lastRow));
                logger.info((Object)("Columns : " + colsCnt));
                retobj = new Object[lastRow - firstRow][colsCnt - firstCol];
                int row = firstRow;
                while (row < lastRow) {
                    Cell[] cells = sheet.getRow(row);
                    int col = firstCol;
                    while (col < cells.length) {
                        retobj[row - firstRow][col - firstCol] = cells[col].getContents();
                        ++col;
                    }
                    ++row;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error while fetching data from " + file), (Throwable)e);
                throw new DataProviderException("Error while fetching data from " + file, e);
            }
        }
        catch (Throwable throwable) {
            try {
                workbook.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            workbook.close();
        }
        catch (Exception exception) {}
        return retobj;
    }

    public static Object[][] getExcelData(String file, boolean headerRow) {
        return ExcelUtil.getExcelData(file, headerRow, "");
    }

    public static String[][] getTableData(String xlFilePath, String tableName, String sheetName) {
        File f;
        Workbook workbook;
        String[][] tabArray;
        block16: {
            tabArray = null;
            workbook = null;
            f = new File(xlFilePath);
            if (f.exists() && f.canRead()) break block16;
            logger.error((Object)(" Can not read file " + f.getAbsolutePath() + " Returning empty dataset1"));
            String[][] stringArray = new String[][]{};
            try {
                workbook.close();
            }
            catch (Exception exception) {}
            return stringArray;
        }
        try {
            try {
                Sheet sheet;
                workbook = Workbook.getWorkbook((File)f);
                Sheet sheet2 = sheet = StringUtils.isNotBlank((String)sheetName) ? workbook.getSheet(sheetName) : workbook.getSheet(0);
                if (sheet == null) {
                    throw new RuntimeException("Worksheet " + sheetName + " not found in " + f.getAbsolutePath());
                }
                Cell tableStart = sheet.findCell(tableName);
                if (tableStart == null) {
                    throw new RuntimeException("Lable " + tableName + " for starting data range not found in sheet " + sheet.getName());
                }
                int startRow = tableStart.getRow();
                int startCol = tableStart.getColumn();
                Cell tableEnd = sheet.findCell(tableName, startCol + 1, startRow + 1, 100, 64000, false);
                if (tableEnd == null) {
                    throw new RuntimeException("Lable " + tableName + " for ending data range not found in sheet " + sheet.getName());
                }
                int endRow = tableEnd.getRow();
                int endCol = tableEnd.getColumn();
                logger.debug((Object)("startRow=" + startRow + ", endRow=" + endRow + ", " + "startCol=" + startCol + ", endCol=" + endCol));
                tabArray = new String[endRow - startRow - 1][endCol - startCol - 1];
                int ci = 0;
                int i = startRow + 1;
                while (i < endRow) {
                    int cj = 0;
                    int j = startCol + 1;
                    while (j < endCol) {
                        tabArray[ci][cj] = sheet.getCell(j, i).getContents();
                        ++j;
                        ++cj;
                    }
                    ++i;
                    ++ci;
                }
            }
            catch (Exception e) {
                logger.error((Object)("error while fetching data from " + xlFilePath), (Throwable)e);
                throw new DataProviderException("Error while fetching data from " + xlFilePath, e);
            }
        }
        catch (Throwable throwable) {
            try {
                workbook.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            workbook.close();
        }
        catch (Exception exception) {}
        return tabArray;
    }

    public static Object[][] getExcelDataAsMap(String file, String sheetName) {
        File f;
        Workbook workbook;
        Object[][] retobj;
        block17: {
            retobj = null;
            workbook = null;
            f = new File(file);
            if (f.exists() && f.canRead()) break block17;
            logger.error((Object)(" Can not read file " + f.getAbsolutePath() + " Returning empty dataset1"));
            Object[][] objectArray = new Object[][]{};
            try {
                workbook.close();
            }
            catch (Exception exception) {}
            return objectArray;
        }
        try {
            try {
                Sheet sheet;
                workbook = Workbook.getWorkbook((File)f);
                Sheet sheet2 = sheet = StringUtils.isNotBlank((String)sheetName) ? workbook.getSheet(sheetName) : workbook.getSheet(0);
                if (sheet == null) {
                    throw new RuntimeException("Worksheet " + sheetName + " not found in " + f.getAbsolutePath());
                }
                int firstRow = ExcelUtil.getFirstRow(sheet, false);
                int firstCol = ExcelUtil.getFirstCol(sheet);
                int lastRow = sheet.getRows();
                int colsCnt = sheet.getColumns();
                String[] colNames = new String[colsCnt - firstCol];
                logger.info((Object)("Rows : " + lastRow));
                logger.info((Object)("Columns : " + colsCnt));
                retobj = new Object[lastRow - (firstRow + 1)][1];
                int row = firstRow;
                while (row < lastRow) {
                    Cell[] cells = sheet.getRow(row);
                    if (row == firstRow) {
                        int col = firstCol;
                        while (col < firstCol + cells.length) {
                            colNames[col - firstCol] = cells[col].getContents().trim();
                            ++col;
                        }
                    } else {
                        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                        int col = firstCol;
                        while (col < firstCol + cells.length) {
                            map.put(colNames[col - firstCol], StringUtil.toObject(cells[col].getContents()));
                            ++col;
                        }
                        retobj[row - (firstRow + 1)][0] = map;
                    }
                    ++row;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error while fetching data from " + file), (Throwable)e);
                throw new DataProviderException("Error while fetching data from " + file, e);
            }
        }
        catch (Throwable throwable) {
            try {
                workbook.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            workbook.close();
        }
        catch (Exception exception) {}
        return retobj;
    }

    public static Object[][] getTableDataAsMap(String xlFilePath, String tableName, String sheetName) {
        File f;
        Workbook workbook;
        Object[][] tabArray;
        block19: {
            tabArray = null;
            workbook = null;
            f = new File(xlFilePath);
            if (f.exists() && f.canRead()) break block19;
            logger.error((Object)(" Can not read file " + f.getAbsolutePath() + " Returning empty dataset1"));
            Object[][] objectArray = new String[][]{};
            try {
                workbook.close();
            }
            catch (Exception exception) {}
            return objectArray;
        }
        try {
            try {
                Sheet sheet;
                workbook = Workbook.getWorkbook((File)f);
                Sheet sheet2 = sheet = StringUtils.isNotBlank((String)sheetName) ? workbook.getSheet(sheetName) : workbook.getSheet(0);
                if (sheet == null) {
                    throw new RuntimeException("Worksheet " + sheetName + " not found in " + f.getAbsolutePath());
                }
                Cell tableStart = sheet.findCell(tableName);
                if (tableStart == null) {
                    throw new RuntimeException("Lable " + tableName + " for starting data range not found in sheet " + sheet.getName());
                }
                int startRow = tableStart.getRow();
                int startCol = tableStart.getColumn();
                Cell tableEnd = sheet.findCell(tableName, startCol + 1, startRow + 1, 100, 64000, false);
                if (tableEnd == null) {
                    throw new RuntimeException("Lable " + tableName + " for ending data range not found in sheet " + sheet.getName());
                }
                int endRow = tableEnd.getRow();
                int endCol = tableEnd.getColumn();
                logger.debug((Object)("startRow=" + startRow + ", endRow=" + endRow + ", " + "startCol=" + startCol + ", endCol=" + endCol));
                tabArray = new Object[endRow - startRow][1];
                int ci = 0;
                String[] colNames = new String[endCol - startCol - 1];
                int i = startRow;
                while (i <= endRow) {
                    int cj = 0;
                    if (i == startRow) {
                        int j = startCol + 1;
                        while (j < endCol) {
                            colNames[cj] = sheet.getCell(j, i).getContents().trim();
                            logger.debug((Object)("header[" + cj + "] : " + colNames[cj]));
                            ++j;
                            ++cj;
                        }
                    } else {
                        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                        int j = startCol + 1;
                        while (j < endCol) {
                            map.put(colNames[cj], StringUtil.toObject(sheet.getCell(j, i).getContents()));
                            ++j;
                            ++cj;
                        }
                        logger.debug((Object)("Record " + ci + ":" + map));
                        tabArray[ci++][0] = map;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                logger.error((Object)("error while fetching data from " + xlFilePath), (Throwable)e);
                throw new DataProviderException("Error while fetching data from " + xlFilePath, e);
            }
        }
        catch (Throwable throwable) {
            try {
                workbook.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            workbook.close();
        }
        catch (Exception exception) {}
        return tabArray;
    }
}

