/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

public class ImageCompareUtil {
    private static final int baseSize = 300;
    private static final int maxDiff = ConfigurationManager.getBundle().getInt("img.allow.max.diff", 100);

    public boolean contains(String reference, String template, Point start) throws Exception {
        BufferedImage ref = ImageIO.read(new File(reference));
        BufferedImage other = ImageIO.read(new File(template));
        double distance = Double.MAX_VALUE;
        int h = ref.getHeight();
        int w = ref.getWidth();
        System.out.println("px width: " + ref.getData().getWidth() + "px height: " + ref.getData().getHeight());
        System.out.println("width: " + ref.getWidth() + "height: " + ref.getHeight());
        System.out.println("min x: " + ref.getData().getMinX() + " y: " + ref.getData().getMinY());
        int th = other.getHeight();
        int tw = other.getWidth();
        int r = 0;
        while (r <= h - th) {
            int c = 0;
            while (c <= w - tw) {
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(ref);
                pb.add((float)c);
                pb.add((float)r);
                pb.add((float)tw);
                pb.add((float)th);
                pb.add(new InterpolationNearest());
                try {
                    double tdistance = this.calcDistance(this.rescale((RenderedImage)JAI.create((String)"crop", (ParameterBlock)pb)), this.rescale(other));
                    if (tdistance < distance) {
                        distance = tdistance;
                    }
                    if (distance == 0.0) break;
                    System.out.println("distance" + distance + " x: " + r + " y: " + c);
                }
                catch (Exception e) {
                    System.out.print("Error: " + e.toString());
                    e.printStackTrace();
                }
                c += 5;
            }
            if (distance == 0.0) break;
            r += 5;
        }
        return distance < (double)maxDiff;
    }

    public boolean compare(String img1, String img2) throws IOException {
        return this.getDifference(img1, img2) < (double)maxDiff;
    }

    public double getDifference(String img1, String img2) throws IOException {
        RenderedImage ref = this.rescale(ImageIO.read(new File(img1)));
        RenderedImage other = this.rescale(ImageIO.read(new File(img2)));
        return this.calcDistance(ref, other);
    }

    public boolean doMatch(String img1, String img2, Rectangle ... rectangles) throws IOException {
        BufferedImage search = ImageIO.read(new File(img1));
        BufferedImage template = ImageIO.read(new File(img2));
        return this.doMatch((RenderedImage)search, template, rectangles);
    }

    public boolean doMatch(BufferedImage search, String img2, Rectangle ... rectangles) throws IOException {
        BufferedImage template = ImageIO.read(new File(img2));
        return this.doMatch((RenderedImage)search, template, rectangles);
    }

    public boolean doMatch(RenderedImage search, RenderedImage template, Rectangle ... rectangles) {
        int T_cols;
        int T_rows;
        RandomIter searchiterator = RandomIterFactory.create((RenderedImage)search, null);
        RandomIter templateiterator = RandomIterFactory.create((RenderedImage)template, null);
        double minSAD = Double.MAX_VALUE;
        Rectangle sRect = rectangles == null || rectangles.length < 1 ? new Rectangle() : rectangles[0];
        Rectangle tRect = rectangles == null || rectangles.length < 2 ? new Rectangle() : rectangles[1];
        int n = T_rows = tRect.width > 0 ? tRect.x + tRect.width : template.getWidth();
        int S_rows = sRect.width > 0 ? sRect.x + sRect.width : (tRect.width > 0 ? search.getWidth() - tRect.width : search.getWidth() - template.getWidth());
        int n2 = T_cols = tRect.height > 0 ? tRect.y + tRect.height : template.getHeight();
        int S_cols = sRect.height > 0 ? sRect.y + sRect.height : (tRect.height > 0 ? search.getHeight() - tRect.height : search.getHeight() - template.getHeight());
        double[] p_SearchIMG = new double[5];
        double[] p_TemplateIMG = new double[5];
        double[] S_accum = new double[3];
        Point bMatch = null;
        boolean match = false;
        double SAD = 0.0;
        int samplesCnt = 0;
        int x = 0;
        int y = 0;
        int i = 0;
        int j = 0;
        x = sRect.x;
        while (x <= S_rows) {
            y = sRect.y;
            while (y <= S_cols) {
                match = true;
                SAD = 0.0;
                samplesCnt = 0;
                i = tRect.x;
                while (i < T_rows - 5) {
                    j = tRect.y;
                    while (j < T_cols - 5) {
                        S_accum[2] = 0.0;
                        S_accum[1] = 0.0;
                        S_accum[0] = 0.0;
                        int ploat = 0;
                        while (ploat < 5) {
                            searchiterator.getPixel(x + i + ploat - tRect.x, y + j + ploat - tRect.y, p_SearchIMG);
                            templateiterator.getPixel(i + ploat, j + ploat, p_TemplateIMG);
                            S_accum[0] = S_accum[0] + Math.abs(p_SearchIMG[0] - p_TemplateIMG[0]);
                            S_accum[1] = S_accum[1] + Math.abs(p_SearchIMG[1] - p_TemplateIMG[1]);
                            S_accum[2] = S_accum[2] + Math.abs(p_SearchIMG[2] - p_TemplateIMG[2]);
                            ++ploat;
                        }
                        Double tempSad = (S_accum[0] + S_accum[1] + S_accum[2]) / 5.0;
                        SAD += tempSad.doubleValue();
                        if (tempSad < minSAD) {
                            minSAD = tempSad;
                            bMatch = new Point(x, y);
                        }
                        samplesCnt += 5;
                        if (tempSad > (double)maxDiff) {
                            match = false;
                            break;
                        }
                        j += 5;
                    }
                    i += 5;
                }
                SAD /= (double)samplesCnt;
                if (match) break;
                ++y;
            }
            if (match) break;
            ++x;
        }
        System.out.print("Match: " + match + " x: " + x + " y: " + y + " dist: " + minSAD + " bMatch: " + bMatch + tRect);
        return match;
    }

    private Color[][] calcSignature(RenderedImage i) {
        Color[][] sig = new Color[5][5];
        float[] prop = new float[]{0.1f, 0.3f, 0.5f, 0.7f, 0.9f};
        int x = 0;
        while (x < 5) {
            int y = 0;
            while (y < 5) {
                sig[x][y] = this.averageAround(i, prop[x], prop[y]);
                ++y;
            }
            ++x;
        }
        return sig;
    }

    private Color averageAround(RenderedImage i, double px, double py) {
        return this.averageAround(i, px, py, 300, 300);
    }

    private Color averageAround(RenderedImage i, double px, double py, int width, int height) {
        RandomIter iterator = RandomIterFactory.create((RenderedImage)i, null);
        double[] pixel = new double[5];
        double[] accum = new double[5];
        int sampleSize = 15;
        int numPixels = 0;
        double x = px * (double)width - (double)sampleSize;
        while (x < px * (double)width + (double)sampleSize) {
            try {
                double y = py * (double)height - (double)sampleSize;
                while (y < py * (double)height + (double)sampleSize) {
                    iterator.getPixel((int)x, (int)y, pixel);
                    accum[0] = accum[0] + pixel[0];
                    accum[1] = accum[1] + pixel[1];
                    accum[2] = accum[2] + pixel[2];
                    ++numPixels;
                    y += 1.0;
                }
            }
            catch (Exception exception) {}
            x += 1.0;
        }
        accum[0] = accum[0] / (double)numPixels;
        accum[1] = accum[1] / (double)numPixels;
        accum[2] = accum[2] / (double)numPixels;
        return new Color((int)accum[0], (int)accum[1], (int)accum[2]);
    }

    private double calcDistance(RenderedImage ref, RenderedImage other) {
        Color[][] signature = this.calcSignature(ref);
        Color[][] sigOther = this.calcSignature(other);
        double dist = 0.0;
        int x = 0;
        while (x < 5) {
            int y = 0;
            while (y < 5) {
                int r1 = signature[x][y].getRed();
                int g1 = signature[x][y].getGreen();
                int b1 = signature[x][y].getBlue();
                int r2 = sigOther[x][y].getRed();
                int g2 = sigOther[x][y].getGreen();
                int b2 = sigOther[x][y].getBlue();
                double tempDist = Math.sqrt((r1 - r2) * (r1 - r2) + (g1 - g2) * (g1 - g2) + (b1 - b2) * (b1 - b2));
                dist += tempDist;
                ++y;
            }
            ++x;
        }
        return dist;
    }

    private RenderedImage rescale(RenderedImage i) {
        float scaleW = 300.0f / (float)i.getWidth();
        float scaleH = 300.0f / (float)i.getHeight();
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(i);
        pb.add(scaleW);
        pb.add(scaleH);
        pb.add(0.0f);
        pb.add(0.0f);
        pb.add(new InterpolationNearest());
        return JAI.create((String)"scale", (ParameterBlock)pb);
    }

    public void doAvgMatch(String img1, String img2) throws IOException {
        RenderedOp search = JAI.create((String)"fileload", (Object)img1);
        RandomIter searchiterator = RandomIterFactory.create((RenderedImage)search, null);
        RenderedOp template = JAI.create((String)"fileload", (Object)img2);
        RandomIter templateiterator = RandomIterFactory.create((RenderedImage)template, null);
        int S_rows = search.getWidth();
        int T_rows = template.getWidth();
        int S_cols = search.getHeight();
        int T_cols = template.getHeight();
        double[] p_SearchIMG = new double[5];
        double[] p_TemplateIMG = new double[5];
        int[] accum = new int[3];
        double SAD = 0.0;
        double minSAD = Double.MAX_VALUE;
        int max = T_rows * T_cols;
        Point bMatch = null;
        boolean match = false;
        int x = 0;
        int y = 0;
        int i = 0;
        int j = 0;
        x = 0;
        while (x < S_rows - T_rows) {
            y = 0;
            while (y < S_cols - T_cols) {
                accum[0] = 0;
                accum[1] = 0;
                accum[2] = 0;
                i = 0;
                while (i < T_rows) {
                    j = 0;
                    while (j < T_cols) {
                        templateiterator.getPixel(i, j, p_TemplateIMG);
                        searchiterator.getPixel(x + i, y + j, p_SearchIMG);
                        accum[0] = (int)((double)accum[0] + Math.abs(p_SearchIMG[0] - p_TemplateIMG[0]));
                        accum[1] = (int)((double)accum[1] + Math.abs(p_SearchIMG[1] - p_TemplateIMG[1]));
                        accum[2] = (int)((double)accum[2] + Math.abs(p_SearchIMG[2] - p_TemplateIMG[2]));
                        ++j;
                    }
                    ++i;
                }
                SAD = (accum[0] / max + accum[1] / max + accum[2] / max) / 3;
                if (SAD < minSAD) {
                    minSAD = SAD;
                    bMatch = new Point(x, y);
                }
                if (SAD < 2.0) {
                    minSAD = SAD;
                    bMatch = new Point(x, y);
                    match = true;
                    break;
                }
                System.out.println(" dist: " + SAD);
                ++y;
            }
            if (match) break;
            ++x;
        }
        System.out.println("Match: " + match + " x: " + x + " y: " + y + " dist: " + SAD + " bMatch: " + bMatch + " minSAD: " + minSAD);
    }
}

