/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarFinderUtil {
    private JarFile jarFile;

    public JarFinderUtil(String jarFile) throws IOException {
        this.jarFile = new JarFile(jarFile);
    }

    public Collection<String> getClasses(String pkg) {
        Enumeration<JarEntry> entries = this.jarFile.entries();
        boolean inclucdeChildPkg = false;
        if (pkg.endsWith(".*")) {
            inclucdeChildPkg = true;
            pkg = pkg.substring(0, pkg.length() - 2);
        }
        ArrayList<String> lst = new ArrayList<String>();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName().replaceAll("/", ".");
            if (!name.endsWith(".class") || !name.toLowerCase().startsWith(pkg.toLowerCase()) || !inclucdeChildPkg && StringUtil.countMatches((String)name, (String)".") != StringUtil.countMatches((String)pkg, (String)".") + 2) continue;
            lst.add(name);
        }
        return lst;
    }

    public Collection<String> getClassesBySimpleName(String name) {
        Enumeration<JarEntry> entries = this.jarFile.entries();
        ArrayList<String> lst = new ArrayList<String>();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().toLowerCase().endsWith(String.valueOf(name.toLowerCase()) + ".class")) continue;
            lst.add(entry.getName().replaceAll("/", "."));
        }
        return lst;
    }

    public Collection<String> getAllClasses() {
        Enumeration<JarEntry> entries = this.jarFile.entries();
        ArrayList<String> lst = new ArrayList<String>();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            lst.add(entry.getName().replaceAll("/", "."));
        }
        return lst;
    }

    public List<String> getAllPackages() {
        Enumeration<JarEntry> entries = this.jarFile.entries();
        ArrayList<String> lst = new ArrayList<String>();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.isDirectory()) continue;
            String s = entry.getName();
            lst.add(s.substring(0, s.length()).replaceAll("/", "."));
        }
        return lst;
    }

    public Collection<String> getAllMethods(String className) {
        return null;
    }

    public static void main(String[] args) {
        try {
            JarFinderUtil finderUtil = new JarFinderUtil("./dist/selenium-automation-framework.jar");
            Collection<String> lst = finderUtil.getClasses("com.qmetry.qaf.automation");
            for (String element : lst) {
                System.out.println(element);
            }
            lst = finderUtil.getClassesBySimpleName("ConfigurationManager");
            for (String element : lst) {
                System.out.println(element);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

