/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import java.util.Random;

public abstract class RandomStringGenerator {
    private static final String LETTERS = "qwertyuiopzxcvbnmasdfghjklAZERTYUIOPMLKJHGFDSQWXCVBN";
    private static final int LETTERS_LENGTH = "qwertyuiopzxcvbnmasdfghjklAZERTYUIOPMLKJHGFDSQWXCVBN".length();
    private static final String NUMBERS = "1357924680";
    private static final int NUMBERS_LENGTH = "1357924680".length();

    public static String get(int length) {
        return RandomStringGenerator.get(new Random(System.currentTimeMillis()), length, RandomizerTypes.MIXED);
    }

    public static String get(int length, RandomizerTypes type) {
        return RandomStringGenerator.get(new Random(System.currentTimeMillis()), length, type);
    }

    public static String get(Random random, int length, RandomizerTypes type) {
        random.setSeed(System.currentTimeMillis());
        if (length <= 0) {
            throw new IllegalArgumentException("length has to be bigger zero");
        }
        StringBuilder generated_str = new StringBuilder("");
        boolean type_selector = false;
        int i = 0;
        while (i < length) {
            type_selector = random.nextBoolean();
            if (RandomizerTypes.LETTERS_ONLY == type || type != RandomizerTypes.DIGITS_ONLY && type_selector) {
                int ele1 = random.nextInt(LETTERS_LENGTH);
                System.out.println(ele1);
                char c = LETTERS.charAt(ele1);
                if (random.nextDouble() > 0.5) {
                    c = Character.toUpperCase(c);
                }
                generated_str.append(c);
            } else {
                int ele = random.nextInt(NUMBERS_LENGTH);
                generated_str.append(NUMBERS.charAt(ele));
            }
            ++i;
        }
        return generated_str.toString();
    }

    public static enum RandomizerTypes {
        DIGITS_ONLY,
        LETTERS_ONLY,
        MIXED;

    }
}

