/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.step.JavaStep;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public final class StackTraceUtils {
    public static final String LINE_NUMBER_SEPARATOR = "#";
    private static final String WAIT_CLASS_NAME = "Wait";

    private StackTraceUtils() {
    }

    public static boolean isWaitInvolved() {
        return StackTraceUtils.isClassInStackTrace(Thread.currentThread().getStackTrace(), ".Wait");
    }

    public static StackTraceElement getCurrentCallingClassAsStackTraceElement() {
        return StackTraceUtils.getCurrentCallingClassAsStackTraceElement(Thread.currentThread().getStackTrace(), "DefaultSelenium");
    }

    public static void debugStackTrace() {
        StackTraceElement[] testElements;
        StackTraceElement[] stackTraceElementArray = testElements = Thread.currentThread().getStackTrace();
        int n = testElements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            System.out.println(StackTraceUtils.stackTraceElementWithLinenumber(stackTraceElement));
            ++n2;
        }
    }

    public static String stackTraceElementWithLinenumber(StackTraceElement stackTraceElement) {
        if (stackTraceElement != null) {
            return String.valueOf(stackTraceElement.getClassName()) + LINE_NUMBER_SEPARATOR + stackTraceElement.getLineNumber();
        }
        return "Internal ERROR stackTraceElement should not be null";
    }

    public static boolean containsClassName(StackTraceElement stackTraceElement, String classNameToSearch) {
        String className = stackTraceElement.getClassName();
        return className.contains(classNameToSearch);
    }

    public static StackTraceElement getCurrentCallingClassAsStackTraceElement(StackTraceElement[] traceElements, String preceedingClassName) {
        boolean found = false;
        StackTraceElement currentCallingClassAsStackTraceElement = null;
        StackTraceElement[] stackTraceElementArray = traceElements;
        int n = traceElements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            if (found) {
                currentCallingClassAsStackTraceElement = stackTraceElement;
                break;
            }
            if (StackTraceUtils.containsClassName(stackTraceElement, preceedingClassName)) {
                found = true;
                currentCallingClassAsStackTraceElement = stackTraceElement;
            }
            ++n2;
        }
        return currentCallingClassAsStackTraceElement;
    }

    public static boolean isClassInStackTrace(StackTraceElement[] traceElements, String className) {
        boolean result = false;
        StackTraceElement[] stackTraceElementArray = traceElements;
        int n = traceElements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            if (stackTraceElement.getClassName().endsWith(className)) {
                return true;
            }
            ++n2;
        }
        return result;
    }

    public static StackTraceElement[] getStackTrace(Throwable t, TestStep step) {
        String filePath = StringUtil.isBlank((String)step.getFileName()) ? "" : FileUtil.getRelativePath(step.getFileName(), "./");
        String declaringClass = "";
        if (step instanceof JavaStep) {
            JavaStep javaStep = (JavaStep)step;
            declaringClass = javaStep.getMethod().getDeclaringClass().getCanonicalName();
        }
        StackTraceElement stackTraceElement = new StackTraceElement(declaringClass, step.getName(), filePath, step.getLineNumber());
        ArrayList<StackTraceElement> l = t != null ? new ArrayList<StackTraceElement>(Arrays.asList(t.getStackTrace())) : new ArrayList();
        l.add(0, stackTraceElement);
        Iterator<StackTraceElement> eles = l.iterator();
        while (eles.hasNext()) {
            StackTraceElement ele = eles.next();
            if (!StringUtil.isNotBlank((String)ele.getClassName()) || !StringMatcher.like(".*(\\.reflect\\.|AjcClosure|org\\.testng\\.).*").match(ele.getClassName())) continue;
            eles.remove();
        }
        return l.toArray(new StackTraceElement[0]);
    }
}

