/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.qmetry.qaf.automation.step.client.TestNGScenario;
import java.util.List;
import org.testng.IClass;
import org.testng.ITest;
import org.testng.ITestClass;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.RunInfo;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

class TestClass
extends NoOpTestClass
implements ITestClass {
    private static final long serialVersionUID = -8077917128278361294L;
    private transient IAnnotationFinder m_annotationFinder = null;
    private transient ITestMethodFinder m_testMethodFinder = null;
    private IClass m_iClass = null;
    private RunInfo m_runInfo = null;
    private String m_testName;
    private XmlTest m_xmlTest;
    private XmlClass m_xmlClass;

    protected TestClass(IClass cls, ITestMethodFinder testMethodFinder, IAnnotationFinder annotationFinder, RunInfo runInfo, XmlTest xmlTest, XmlClass xmlClass) {
        this.init(cls, testMethodFinder, annotationFinder, runInfo, xmlTest, xmlClass);
    }

    public String getTestName() {
        return this.m_testName;
    }

    public XmlTest getXmlTest() {
        return this.m_xmlTest;
    }

    public XmlClass getXmlClass() {
        return this.m_xmlClass;
    }

    public IAnnotationFinder getAnnotationFinder() {
        return this.m_annotationFinder;
    }

    private void init(IClass cls, ITestMethodFinder testMethodFinder, IAnnotationFinder annotationFinder, RunInfo runInfo, XmlTest xmlTest, XmlClass xmlClass) {
        this.log(3, "Creating TestClass for " + cls);
        this.m_iClass = cls;
        this.m_testClass = cls.getRealClass();
        this.m_xmlTest = xmlTest;
        this.m_xmlClass = xmlClass;
        this.m_runInfo = runInfo;
        this.m_testMethodFinder = testMethodFinder;
        this.m_annotationFinder = annotationFinder;
        this.initTestClassesAndInstances();
        this.initMethods();
    }

    private void initTestClassesAndInstances() {
        Object[] instances;
        Object[] objectArray = instances = this.getInstances(false);
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            Object instance = objectArray[n2];
            if (instance instanceof ITest) {
                this.m_testName = ((ITest)instance).getTestName();
                break;
            }
            ++n2;
        }
        if (this.m_testName == null) {
            this.m_testName = this.m_iClass.getTestName();
        }
    }

    public Object[] getInstances(boolean create) {
        return this.m_iClass.getInstances(create);
    }

    public long[] getInstanceHashCodes() {
        return this.m_iClass.getInstanceHashCodes();
    }

    @Deprecated
    public int getInstanceCount() {
        return this.m_iClass.getInstanceCount();
    }

    public void addInstance(Object instance) {
        this.m_iClass.addInstance(instance);
    }

    private void initMethods() {
        ITestNGMethod[] methods = this.m_testMethodFinder.getTestMethods(this.m_testClass, this.m_xmlTest);
        this.m_testMethods = this.createTestMethods(methods);
        Object[] objectArray = this.m_iClass.getInstances(false);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object instance = objectArray[n2];
            this.m_beforeSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods((ITestNGMethod[])this.m_testMethodFinder.getBeforeSuiteMethods(this.m_testClass), (IAnnotationFinder)this.m_annotationFinder, (boolean)true, (Object)instance);
            this.m_afterSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods((ITestNGMethod[])this.m_testMethodFinder.getAfterSuiteMethods(this.m_testClass), (IAnnotationFinder)this.m_annotationFinder, (boolean)false, (Object)instance);
            this.m_beforeTestConfMethods = ConfigurationMethod.createTestConfigurationMethods((ITestNGMethod[])this.m_testMethodFinder.getBeforeTestConfigurationMethods(this.m_testClass), (IAnnotationFinder)this.m_annotationFinder, (boolean)true, (Object)instance);
            this.m_afterTestConfMethods = ConfigurationMethod.createTestConfigurationMethods((ITestNGMethod[])this.m_testMethodFinder.getAfterTestConfigurationMethods(this.m_testClass), (IAnnotationFinder)this.m_annotationFinder, (boolean)false, (Object)instance);
            this.m_beforeClassMethods = ConfigurationMethod.createClassConfigurationMethods((ITestNGMethod[])this.m_testMethodFinder.getBeforeClassMethods(this.m_testClass), (IAnnotationFinder)this.m_annotationFinder, (boolean)true, (Object)instance);
            this.m_afterClassMethods = ConfigurationMethod.createClassConfigurationMethods((ITestNGMethod[])this.m_testMethodFinder.getAfterClassMethods(this.m_testClass), (IAnnotationFinder)this.m_annotationFinder, (boolean)false, (Object)instance);
            this.m_beforeGroupsMethods = ConfigurationMethod.createBeforeConfigurationMethods((ITestNGMethod[])this.m_testMethodFinder.getBeforeGroupsConfigurationMethods(this.m_testClass), (IAnnotationFinder)this.m_annotationFinder, (boolean)true, (Object)instance);
            this.m_afterGroupsMethods = ConfigurationMethod.createAfterConfigurationMethods((ITestNGMethod[])this.m_testMethodFinder.getAfterGroupsConfigurationMethods(this.m_testClass), (IAnnotationFinder)this.m_annotationFinder, (boolean)false, (Object)instance);
            this.m_beforeTestMethods = ConfigurationMethod.createTestMethodConfigurationMethods((ITestNGMethod[])this.m_testMethodFinder.getBeforeTestMethods(this.m_testClass), (IAnnotationFinder)this.m_annotationFinder, (boolean)true, (Object)instance);
            this.m_afterTestMethods = ConfigurationMethod.createTestMethodConfigurationMethods((ITestNGMethod[])this.m_testMethodFinder.getAfterTestMethods(this.m_testClass), (IAnnotationFinder)this.m_annotationFinder, (boolean)false, (Object)instance);
            ++n2;
        }
    }

    private ITestNGMethod[] createTestMethods(ITestNGMethod[] methods) {
        List vResult = Lists.newArrayList();
        ITestNGMethod[] iTestNGMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ITestNGMethod tm = iTestNGMethodArray[n2];
            ConstructorOrMethod m = tm.getConstructorOrMethod();
            if (m.getDeclaringClass().isAssignableFrom(this.m_testClass)) {
                Object[] objectArray = this.m_iClass.getInstances(false);
                int n3 = objectArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object o = objectArray[n4];
                    this.log(4, "Adding method " + tm + " on TestClass " + this.m_testClass);
                    vResult.add(new TestNGScenario(m.getMethod(), this.m_annotationFinder, this.m_xmlTest, o));
                    ++n4;
                }
            } else {
                this.log(4, "Rejecting method " + tm + " for TestClass " + this.m_testClass);
            }
            ++n2;
        }
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    private RunInfo getRunInfo() {
        return this.m_runInfo;
    }

    public ITestMethodFinder getTestMethodFinder() {
        return this.m_testMethodFinder;
    }

    private void log(int level, String s) {
        Utils.log((String)"TestClass", (int)level, (String)s);
    }

    private static void ppp(String s) {
        System.out.println("[TestClass] " + s);
    }

    protected void dump() {
        ITestNGMethod m;
        System.out.println("===== Test class\n" + this.m_testClass.getName());
        ITestNGMethod[] iTestNGMethodArray = this.m_beforeClassMethods;
        int n = this.m_beforeClassMethods.length;
        int n2 = 0;
        while (n2 < n) {
            m = iTestNGMethodArray[n2];
            System.out.println("  @BeforeClass " + m);
            ++n2;
        }
        iTestNGMethodArray = this.m_beforeTestMethods;
        n = this.m_beforeTestMethods.length;
        n2 = 0;
        while (n2 < n) {
            m = iTestNGMethodArray[n2];
            System.out.println("  @BeforeMethod " + m);
            ++n2;
        }
        iTestNGMethodArray = this.m_testMethods;
        n = this.m_testMethods.length;
        n2 = 0;
        while (n2 < n) {
            m = iTestNGMethodArray[n2];
            System.out.println("    @Test " + m);
            ++n2;
        }
        iTestNGMethodArray = this.m_afterTestMethods;
        n = this.m_afterTestMethods.length;
        n2 = 0;
        while (n2 < n) {
            m = iTestNGMethodArray[n2];
            System.out.println("  @AfterMethod " + m);
            ++n2;
        }
        iTestNGMethodArray = this.m_afterClassMethods;
        n = this.m_afterClassMethods.length;
        n2 = 0;
        while (n2 < n) {
            m = iTestNGMethodArray[n2];
            System.out.println("  @AfterClass " + m);
            ++n2;
        }
        System.out.println("======");
    }

    public String toString() {
        return Objects.toStringHelper(((Object)((Object)this)).getClass()).add("name", (Object)this.m_testClass).toString();
    }

    public IClass getIClass() {
        return this.m_iClass;
    }
}

