/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.Method;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.ContentHeaderPropertyReader;
import com.rabbitmq.client.impl.ContentHeaderPropertyWriter;
import com.rabbitmq.client.impl.LongString;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public interface AMQP {
    public static final int FRAME_METHOD = 1;
    public static final int FRAME_HEADER = 2;
    public static final int FRAME_BODY = 3;
    public static final int FRAME_OOB_METHOD = 4;
    public static final int FRAME_OOB_HEADER = 5;
    public static final int FRAME_OOB_BODY = 6;
    public static final int FRAME_TRACE = 7;
    public static final int FRAME_HEARTBEAT = 8;
    public static final int FRAME_MIN_SIZE = 4096;
    public static final int FRAME_END = 206;
    public static final int REPLY_SUCCESS = 200;
    public static final int NOT_DELIVERED = 310;
    public static final int CONTENT_TOO_LARGE = 311;
    public static final int CONNECTION_FORCED = 320;
    public static final int INVALID_PATH = 402;
    public static final int ACCESS_REFUSED = 403;
    public static final int NOT_FOUND = 404;
    public static final int RESOURCE_LOCKED = 405;
    public static final int FRAME_ERROR = 501;
    public static final int SYNTAX_ERROR = 502;
    public static final int COMMAND_INVALID = 503;
    public static final int CHANNEL_ERROR = 504;
    public static final int RESOURCE_ERROR = 506;
    public static final int NOT_ALLOWED = 530;
    public static final int NOT_IMPLEMENTED = 540;
    public static final int INTERNAL_ERROR = 541;

    public static class TestProperties
    extends AMQContentHeader {
        public int getClassId() {
            return 120;
        }

        public String getClassName() {
            return "test";
        }

        public void readPropertiesFrom(ContentHeaderPropertyReader reader) throws IOException {
        }

        public void writePropertiesTo(ContentHeaderPropertyWriter writer) throws IOException {
        }

        public void appendPropertyDebugStringTo(StringBuffer acc) {
            acc.append("(");
            acc.append(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TunnelProperties
    extends AMQContentHeader {
        public Map<String, Object> headers;
        public String proxyName;
        public String dataName;
        public Integer durable;
        public Integer broadcast;

        public TunnelProperties(Map<String, Object> headers, String proxyName, String dataName, Integer durable, Integer broadcast) {
            this.headers = headers;
            this.proxyName = proxyName;
            this.dataName = dataName;
            this.durable = durable;
            this.broadcast = broadcast;
        }

        public TunnelProperties() {
        }

        @Override
        public int getClassId() {
            return 110;
        }

        @Override
        public String getClassName() {
            return "tunnel";
        }

        @Override
        public void readPropertiesFrom(ContentHeaderPropertyReader reader) throws IOException {
            this.headers = reader.readTable();
            this.proxyName = reader.readShortstr();
            this.dataName = reader.readShortstr();
            this.durable = reader.readOctet();
            this.broadcast = reader.readOctet();
        }

        @Override
        public void writePropertiesTo(ContentHeaderPropertyWriter writer) throws IOException {
            writer.writeTable(this.headers);
            writer.writeShortstr(this.proxyName);
            writer.writeShortstr(this.dataName);
            writer.writeOctet(this.durable);
            writer.writeOctet(this.broadcast);
        }

        @Override
        public void appendPropertyDebugStringTo(StringBuffer acc) {
            acc.append("(");
            acc.append("headers=");
            acc.append(this.headers);
            acc.append(", ");
            acc.append("proxy name=");
            acc.append(this.proxyName);
            acc.append(", ");
            acc.append("data name=");
            acc.append(this.dataName);
            acc.append(", ");
            acc.append("durable=");
            acc.append(this.durable);
            acc.append(", ");
            acc.append("broadcast=");
            acc.append(this.broadcast);
            acc.append(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StreamProperties
    extends AMQContentHeader {
        public String contentType;
        public String contentEncoding;
        public Map<String, Object> headers;
        public Integer priority;
        public Date timestamp;

        public StreamProperties(String contentType, String contentEncoding, Map<String, Object> headers, Integer priority, Date timestamp) {
            this.contentType = contentType;
            this.contentEncoding = contentEncoding;
            this.headers = headers;
            this.priority = priority;
            this.timestamp = timestamp;
        }

        public StreamProperties() {
        }

        @Override
        public int getClassId() {
            return 80;
        }

        @Override
        public String getClassName() {
            return "stream";
        }

        @Override
        public void readPropertiesFrom(ContentHeaderPropertyReader reader) throws IOException {
            this.contentType = reader.readShortstr();
            this.contentEncoding = reader.readShortstr();
            this.headers = reader.readTable();
            this.priority = reader.readOctet();
            this.timestamp = reader.readTimestamp();
        }

        @Override
        public void writePropertiesTo(ContentHeaderPropertyWriter writer) throws IOException {
            writer.writeShortstr(this.contentType);
            writer.writeShortstr(this.contentEncoding);
            writer.writeTable(this.headers);
            writer.writeOctet(this.priority);
            writer.writeTimestamp(this.timestamp);
        }

        @Override
        public void appendPropertyDebugStringTo(StringBuffer acc) {
            acc.append("(");
            acc.append("content type=");
            acc.append(this.contentType);
            acc.append(", ");
            acc.append("content encoding=");
            acc.append(this.contentEncoding);
            acc.append(", ");
            acc.append("headers=");
            acc.append(this.headers);
            acc.append(", ");
            acc.append("priority=");
            acc.append(this.priority);
            acc.append(", ");
            acc.append("timestamp=");
            acc.append(this.timestamp);
            acc.append(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileProperties
    extends AMQContentHeader {
        public String contentType;
        public String contentEncoding;
        public Map<String, Object> headers;
        public Integer priority;
        public String replyTo;
        public String messageId;
        public String filename;
        public Date timestamp;
        public String clusterId;

        public FileProperties(String contentType, String contentEncoding, Map<String, Object> headers, Integer priority, String replyTo, String messageId, String filename, Date timestamp, String clusterId) {
            this.contentType = contentType;
            this.contentEncoding = contentEncoding;
            this.headers = headers;
            this.priority = priority;
            this.replyTo = replyTo;
            this.messageId = messageId;
            this.filename = filename;
            this.timestamp = timestamp;
            this.clusterId = clusterId;
        }

        public FileProperties() {
        }

        @Override
        public int getClassId() {
            return 70;
        }

        @Override
        public String getClassName() {
            return "file";
        }

        @Override
        public void readPropertiesFrom(ContentHeaderPropertyReader reader) throws IOException {
            this.contentType = reader.readShortstr();
            this.contentEncoding = reader.readShortstr();
            this.headers = reader.readTable();
            this.priority = reader.readOctet();
            this.replyTo = reader.readShortstr();
            this.messageId = reader.readShortstr();
            this.filename = reader.readShortstr();
            this.timestamp = reader.readTimestamp();
            this.clusterId = reader.readShortstr();
        }

        @Override
        public void writePropertiesTo(ContentHeaderPropertyWriter writer) throws IOException {
            writer.writeShortstr(this.contentType);
            writer.writeShortstr(this.contentEncoding);
            writer.writeTable(this.headers);
            writer.writeOctet(this.priority);
            writer.writeShortstr(this.replyTo);
            writer.writeShortstr(this.messageId);
            writer.writeShortstr(this.filename);
            writer.writeTimestamp(this.timestamp);
            writer.writeShortstr(this.clusterId);
        }

        @Override
        public void appendPropertyDebugStringTo(StringBuffer acc) {
            acc.append("(");
            acc.append("content type=");
            acc.append(this.contentType);
            acc.append(", ");
            acc.append("content encoding=");
            acc.append(this.contentEncoding);
            acc.append(", ");
            acc.append("headers=");
            acc.append(this.headers);
            acc.append(", ");
            acc.append("priority=");
            acc.append(this.priority);
            acc.append(", ");
            acc.append("reply to=");
            acc.append(this.replyTo);
            acc.append(", ");
            acc.append("message id=");
            acc.append(this.messageId);
            acc.append(", ");
            acc.append("filename=");
            acc.append(this.filename);
            acc.append(", ");
            acc.append("timestamp=");
            acc.append(this.timestamp);
            acc.append(", ");
            acc.append("cluster id=");
            acc.append(this.clusterId);
            acc.append(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BasicProperties
    extends AMQContentHeader {
        public String contentType;
        public String contentEncoding;
        public Map<String, Object> headers;
        public Integer deliveryMode;
        public Integer priority;
        public String correlationId;
        public String replyTo;
        public String expiration;
        public String messageId;
        public Date timestamp;
        public String type;
        public String userId;
        public String appId;
        public String clusterId;

        public BasicProperties(String contentType, String contentEncoding, Map<String, Object> headers, Integer deliveryMode, Integer priority, String correlationId, String replyTo, String expiration, String messageId, Date timestamp, String type, String userId, String appId, String clusterId) {
            this.contentType = contentType;
            this.contentEncoding = contentEncoding;
            this.headers = headers;
            this.deliveryMode = deliveryMode;
            this.priority = priority;
            this.correlationId = correlationId;
            this.replyTo = replyTo;
            this.expiration = expiration;
            this.messageId = messageId;
            this.timestamp = timestamp;
            this.type = type;
            this.userId = userId;
            this.appId = appId;
            this.clusterId = clusterId;
        }

        public BasicProperties() {
        }

        @Override
        public int getClassId() {
            return 60;
        }

        @Override
        public String getClassName() {
            return "basic";
        }

        @Override
        public void readPropertiesFrom(ContentHeaderPropertyReader reader) throws IOException {
            this.contentType = reader.readShortstr();
            this.contentEncoding = reader.readShortstr();
            this.headers = reader.readTable();
            this.deliveryMode = reader.readOctet();
            this.priority = reader.readOctet();
            this.correlationId = reader.readShortstr();
            this.replyTo = reader.readShortstr();
            this.expiration = reader.readShortstr();
            this.messageId = reader.readShortstr();
            this.timestamp = reader.readTimestamp();
            this.type = reader.readShortstr();
            this.userId = reader.readShortstr();
            this.appId = reader.readShortstr();
            this.clusterId = reader.readShortstr();
        }

        @Override
        public void writePropertiesTo(ContentHeaderPropertyWriter writer) throws IOException {
            writer.writeShortstr(this.contentType);
            writer.writeShortstr(this.contentEncoding);
            writer.writeTable(this.headers);
            writer.writeOctet(this.deliveryMode);
            writer.writeOctet(this.priority);
            writer.writeShortstr(this.correlationId);
            writer.writeShortstr(this.replyTo);
            writer.writeShortstr(this.expiration);
            writer.writeShortstr(this.messageId);
            writer.writeTimestamp(this.timestamp);
            writer.writeShortstr(this.type);
            writer.writeShortstr(this.userId);
            writer.writeShortstr(this.appId);
            writer.writeShortstr(this.clusterId);
        }

        @Override
        public void appendPropertyDebugStringTo(StringBuffer acc) {
            acc.append("(");
            acc.append("content type=");
            acc.append(this.contentType);
            acc.append(", ");
            acc.append("content encoding=");
            acc.append(this.contentEncoding);
            acc.append(", ");
            acc.append("headers=");
            acc.append(this.headers);
            acc.append(", ");
            acc.append("delivery mode=");
            acc.append(this.deliveryMode);
            acc.append(", ");
            acc.append("priority=");
            acc.append(this.priority);
            acc.append(", ");
            acc.append("correlation id=");
            acc.append(this.correlationId);
            acc.append(", ");
            acc.append("reply to=");
            acc.append(this.replyTo);
            acc.append(", ");
            acc.append("expiration=");
            acc.append(this.expiration);
            acc.append(", ");
            acc.append("message id=");
            acc.append(this.messageId);
            acc.append(", ");
            acc.append("timestamp=");
            acc.append(this.timestamp);
            acc.append(", ");
            acc.append("type=");
            acc.append(this.type);
            acc.append(", ");
            acc.append("user id=");
            acc.append(this.userId);
            acc.append(", ");
            acc.append("app id=");
            acc.append(this.appId);
            acc.append(", ");
            acc.append("cluster id=");
            acc.append(this.clusterId);
            acc.append(")");
        }
    }

    public static class Test {

        public static interface ContentOk
        extends Method {
            public int getContentChecksum();
        }

        public static interface Content
        extends Method {
        }

        public static interface TableOk
        extends Method {
            public long getIntegerResult();

            public LongString getStringResult();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Table
        extends Method {
            public Map<java.lang.String, Object> getTable();

            public int getIntegerOp();

            public int getStringOp();
        }

        public static interface StringOk
        extends Method {
            public LongString getResult();
        }

        public static interface String
        extends Method {
            public java.lang.String getString1();

            public LongString getString2();

            public int getOperation();
        }

        public static interface IntegerOk
        extends Method {
            public long getResult();
        }

        public static interface Integer
        extends Method {
            public int getInteger1();

            public int getInteger2();

            public int getInteger3();

            public long getInteger4();

            public int getOperation();
        }
    }

    public static class Tunnel {

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Request
        extends Method {
            public Map<String, Object> getMetaData();
        }
    }

    public static class Dtx {

        public static interface StartOk
        extends Method {
        }

        public static interface Start
        extends Method {
            public String getDtxIdentifier();
        }

        public static interface SelectOk
        extends Method {
        }

        public static interface Select
        extends Method {
        }
    }

    public static class Tx {

        public static interface RollbackOk
        extends Method {
        }

        public static interface Rollback
        extends Method {
        }

        public static interface CommitOk
        extends Method {
        }

        public static interface Commit
        extends Method {
        }

        public static interface SelectOk
        extends Method {
        }

        public static interface Select
        extends Method {
        }
    }

    public static class Stream {

        public static interface Deliver
        extends Method {
            public String getConsumerTag();

            public long getDeliveryTag();

            public String getExchange();

            public String getQueue();
        }

        public static interface Return
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public String getExchange();

            public String getRoutingKey();
        }

        public static interface Publish
        extends Method {
            public int getTicket();

            public String getExchange();

            public String getRoutingKey();

            public boolean getMandatory();

            public boolean getImmediate();
        }

        public static interface CancelOk
        extends Method {
            public String getConsumerTag();
        }

        public static interface Cancel
        extends Method {
            public String getConsumerTag();

            public boolean getNowait();
        }

        public static interface ConsumeOk
        extends Method {
            public String getConsumerTag();
        }

        public static interface Consume
        extends Method {
            public int getTicket();

            public String getQueue();

            public String getConsumerTag();

            public boolean getNoLocal();

            public boolean getExclusive();

            public boolean getNowait();
        }

        public static interface QosOk
        extends Method {
        }

        public static interface Qos
        extends Method {
            public int getPrefetchSize();

            public int getPrefetchCount();

            public int getConsumeRate();

            public boolean getGlobal();
        }
    }

    public static class File {

        public static interface Reject
        extends Method {
            public long getDeliveryTag();

            public boolean getRequeue();
        }

        public static interface Ack
        extends Method {
            public long getDeliveryTag();

            public boolean getMultiple();
        }

        public static interface Deliver
        extends Method {
            public String getConsumerTag();

            public long getDeliveryTag();

            public boolean getRedelivered();

            public String getExchange();

            public String getRoutingKey();

            public String getIdentifier();
        }

        public static interface Return
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public String getExchange();

            public String getRoutingKey();
        }

        public static interface Publish
        extends Method {
            public int getTicket();

            public String getExchange();

            public String getRoutingKey();

            public boolean getMandatory();

            public boolean getImmediate();

            public String getIdentifier();
        }

        public static interface Stage
        extends Method {
        }

        public static interface OpenOk
        extends Method {
            public long getStagedSize();
        }

        public static interface Open
        extends Method {
            public String getIdentifier();

            public long getContentSize();
        }

        public static interface CancelOk
        extends Method {
            public String getConsumerTag();
        }

        public static interface Cancel
        extends Method {
            public String getConsumerTag();

            public boolean getNowait();
        }

        public static interface ConsumeOk
        extends Method {
            public String getConsumerTag();
        }

        public static interface Consume
        extends Method {
            public int getTicket();

            public String getQueue();

            public String getConsumerTag();

            public boolean getNoLocal();

            public boolean getNoAck();

            public boolean getExclusive();

            public boolean getNowait();
        }

        public static interface QosOk
        extends Method {
        }

        public static interface Qos
        extends Method {
            public int getPrefetchSize();

            public int getPrefetchCount();

            public boolean getGlobal();
        }
    }

    public static class Basic {

        public static interface Recover
        extends Method {
            public boolean getRequeue();
        }

        public static interface Reject
        extends Method {
            public long getDeliveryTag();

            public boolean getRequeue();
        }

        public static interface Ack
        extends Method {
            public long getDeliveryTag();

            public boolean getMultiple();
        }

        public static interface GetEmpty
        extends Method {
            public String getClusterId();
        }

        public static interface GetOk
        extends Method {
            public long getDeliveryTag();

            public boolean getRedelivered();

            public String getExchange();

            public String getRoutingKey();

            public int getMessageCount();
        }

        public static interface Get
        extends Method {
            public int getTicket();

            public String getQueue();

            public boolean getNoAck();
        }

        public static interface Deliver
        extends Method {
            public String getConsumerTag();

            public long getDeliveryTag();

            public boolean getRedelivered();

            public String getExchange();

            public String getRoutingKey();
        }

        public static interface Return
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public String getExchange();

            public String getRoutingKey();
        }

        public static interface Publish
        extends Method {
            public int getTicket();

            public String getExchange();

            public String getRoutingKey();

            public boolean getMandatory();

            public boolean getImmediate();
        }

        public static interface CancelOk
        extends Method {
            public String getConsumerTag();
        }

        public static interface Cancel
        extends Method {
            public String getConsumerTag();

            public boolean getNowait();
        }

        public static interface ConsumeOk
        extends Method {
            public String getConsumerTag();
        }

        public static interface Consume
        extends Method {
            public int getTicket();

            public String getQueue();

            public String getConsumerTag();

            public boolean getNoLocal();

            public boolean getNoAck();

            public boolean getExclusive();

            public boolean getNowait();
        }

        public static interface QosOk
        extends Method {
        }

        public static interface Qos
        extends Method {
            public int getPrefetchSize();

            public int getPrefetchCount();

            public boolean getGlobal();
        }
    }

    public static class Queue {

        public static interface DeleteOk
        extends Method {
            public int getMessageCount();
        }

        public static interface Delete
        extends Method {
            public int getTicket();

            public String getQueue();

            public boolean getIfUnused();

            public boolean getIfEmpty();

            public boolean getNowait();
        }

        public static interface PurgeOk
        extends Method {
            public int getMessageCount();
        }

        public static interface Purge
        extends Method {
            public int getTicket();

            public String getQueue();

            public boolean getNowait();
        }

        public static interface BindOk
        extends Method {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Bind
        extends Method {
            public int getTicket();

            public String getQueue();

            public String getExchange();

            public String getRoutingKey();

            public boolean getNowait();

            public Map<String, Object> getArguments();
        }

        public static interface DeclareOk
        extends Method {
            public String getQueue();

            public int getMessageCount();

            public int getConsumerCount();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Declare
        extends Method {
            public int getTicket();

            public String getQueue();

            public boolean getPassive();

            public boolean getDurable();

            public boolean getExclusive();

            public boolean getAutoDelete();

            public boolean getNowait();

            public Map<String, Object> getArguments();
        }
    }

    public static class Exchange {

        public static interface DeleteOk
        extends Method {
        }

        public static interface Delete
        extends Method {
            public int getTicket();

            public String getExchange();

            public boolean getIfUnused();

            public boolean getNowait();
        }

        public static interface DeclareOk
        extends Method {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Declare
        extends Method {
            public int getTicket();

            public String getExchange();

            public String getType();

            public boolean getPassive();

            public boolean getDurable();

            public boolean getAutoDelete();

            public boolean getInternal();

            public boolean getNowait();

            public Map<String, Object> getArguments();
        }
    }

    public static class Access {

        public static interface RequestOk
        extends Method {
            public int getTicket();
        }

        public static interface Request
        extends Method {
            public String getRealm();

            public boolean getExclusive();

            public boolean getPassive();

            public boolean getActive();

            public boolean getWrite();

            public boolean getRead();
        }
    }

    public static class Channel {

        public static interface CloseOk
        extends Method {
        }

        public static interface Close
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public int getClassId();

            public int getMethodId();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Alert
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public Map<String, Object> getDetails();
        }

        public static interface FlowOk
        extends Method {
            public boolean getActive();
        }

        public static interface Flow
        extends Method {
            public boolean getActive();
        }

        public static interface OpenOk
        extends Method {
        }

        public static interface Open
        extends Method {
            public String getOutOfBand();
        }
    }

    public static class Connection {

        public static interface CloseOk
        extends Method {
        }

        public static interface Close
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public int getClassId();

            public int getMethodId();
        }

        public static interface Redirect
        extends Method {
            public String getHost();

            public String getKnownHosts();
        }

        public static interface OpenOk
        extends Method {
            public String getKnownHosts();
        }

        public static interface Open
        extends Method {
            public String getVirtualHost();

            public String getCapabilities();

            public boolean getInsist();
        }

        public static interface TuneOk
        extends Method {
            public int getChannelMax();

            public int getFrameMax();

            public int getHeartbeat();
        }

        public static interface Tune
        extends Method {
            public int getChannelMax();

            public int getFrameMax();

            public int getHeartbeat();
        }

        public static interface SecureOk
        extends Method {
            public LongString getResponse();
        }

        public static interface Secure
        extends Method {
            public LongString getChallenge();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface StartOk
        extends Method {
            public Map<String, Object> getClientProperties();

            public String getMechanism();

            public LongString getResponse();

            public String getLocale();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Start
        extends Method {
            public int getVersionMajor();

            public int getVersionMinor();

            public Map<String, Object> getServerProperties();

            public LongString getMechanisms();

            public LongString getLocales();
        }
    }

    public static class PROTOCOL {
        public static final int MAJOR = 8;
        public static final int MINOR = 0;
        public static final int PORT = 5672;
    }
}

