/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionParameters;
import com.rabbitmq.client.RedirectException;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.FrameHandler;
import com.rabbitmq.client.impl.SocketFrameHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFactory {
    private final ConnectionParameters _params;

    public ConnectionFactory() {
        this._params = new ConnectionParameters();
    }

    public ConnectionFactory(ConnectionParameters params) {
        this._params = params;
    }

    public ConnectionParameters getParameters() {
        return this._params;
    }

    protected FrameHandler createFrameHandler(Address addr) throws IOException {
        String hostName = addr.getHost();
        int portNumber = addr.getPort();
        if (portNumber == -1) {
            portNumber = 5672;
        }
        return new SocketFrameHandler(hostName, portNumber);
    }

    private Connection newConnection(Address[] addrs, int maxRedirects, Map<Address, Integer> redirectAttempts) throws IOException {
        IOException lastException = null;
        for (Address addr : addrs) {
            Address[] lastKnownAddresses = new Address[]{};
            try {
                while (true) {
                    FrameHandler frameHandler = this.createFrameHandler(addr);
                    Integer redirectCount = redirectAttempts.get(addr);
                    if (redirectCount == null) {
                        redirectCount = 0;
                    }
                    boolean allowRedirects = redirectCount < maxRedirects;
                    try {
                        return new AMQConnection(this._params, !allowRedirects, frameHandler);
                    }
                    catch (RedirectException e) {
                        if (!allowRedirects) {
                            throw new IOException("server ignored 'insist'");
                        }
                        redirectAttempts.put(addr, redirectCount + 1);
                        lastKnownAddresses = e.getKnownAddresses();
                        addr = e.getAddress();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                lastException = e;
                if (lastKnownAddresses.length <= 0) continue;
                try {
                    return this.newConnection(lastKnownAddresses, maxRedirects, redirectAttempts);
                }
                catch (IOException e1) {
                    lastException = e1;
                }
            }
        }
        if (lastException == null) {
            throw new IOException("failed to connect");
        }
        throw lastException;
    }

    public Connection newConnection(Address[] addrs, int maxRedirects) throws IOException {
        return this.newConnection(addrs, maxRedirects, new HashMap<Address, Integer>());
    }

    public Connection newConnection(Address[] addrs) throws IOException {
        return this.newConnection(addrs, 0);
    }

    public Connection newConnection(String hostName, int portNumber) throws IOException {
        return this.newConnection(new Address[]{new Address(hostName, portNumber)});
    }

    public Connection newConnection(String hostName) throws IOException {
        return this.newConnection(hostName, -1);
    }
}

