/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.utility.ValueOrException;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueingConsumer
extends DefaultConsumer {
    public BlockingQueue<ValueOrException<Delivery, ShutdownSignalException>> _queue;

    public QueueingConsumer(Channel ch) {
        this(ch, new LinkedBlockingQueue<ValueOrException<Delivery, ShutdownSignalException>>());
    }

    public QueueingConsumer(Channel ch, BlockingQueue<ValueOrException<Delivery, ShutdownSignalException>> q) {
        super(ch);
        this._queue = q;
    }

    @Override
    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
        this._queue.add(ValueOrException.makeException(sig));
    }

    @Override
    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        this._queue.add(ValueOrException.makeValue(new Delivery(envelope, properties, body)));
    }

    public Delivery nextDelivery() throws InterruptedException, ShutdownSignalException {
        return this._queue.take().getValue();
    }

    public BlockingQueue<ValueOrException<Delivery, ShutdownSignalException>> getQueue() {
        return this._queue;
    }

    public static class Delivery {
        private final Envelope _envelope;
        private final AMQP.BasicProperties _properties;
        private final byte[] _body;

        public Delivery(Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
            this._envelope = envelope;
            this._properties = properties;
            this._body = body;
        }

        public Envelope getEnvelope() {
            return this._envelope;
        }

        public AMQP.BasicProperties getProperties() {
            return this._properties;
        }

        public byte[] getBody() {
            return this._body;
        }
    }
}

