/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.Command;
import com.rabbitmq.client.ContentHeader;
import com.rabbitmq.client.UnexpectedFrameError;
import com.rabbitmq.client.impl.AMQChannel;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.Method;
import com.rabbitmq.client.impl.MethodArgumentWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AMQCommand
implements Command {
    public static final int EMPTY_CONTENT_BODY_FRAME_SIZE = 8;
    private Method _method;
    private AMQContentHeader _contentHeader;
    private List<byte[]> _content;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static Assembler newAssembler() {
        return new AMQCommand().getFreshAssembler();
    }

    public AMQCommand() {
        this(null, null, null);
    }

    public AMQCommand(Method method) {
        this(method, null, null);
    }

    public AMQCommand(Method method, AMQContentHeader contentHeader, byte[] body) {
        this._method = method;
        this._contentHeader = contentHeader;
        this.setContentBody(body);
    }

    public Method getMethod() {
        return this._method;
    }

    public ContentHeader getContentHeader() {
        return this._contentHeader;
    }

    public byte[] getContentBody() {
        switch (this._content.size()) {
            case 0: {
                return EMPTY_BYTE_ARRAY;
            }
            case 1: {
                return this._content.get(0);
            }
        }
        return this.coalesceContentBody();
    }

    public void setContentBody(byte[] body) {
        ArrayList<byte[]> newContent = new ArrayList<byte[]>();
        if (body != null) {
            newContent.add(body);
        }
        this._content = newContent;
    }

    public byte[] coalesceContentBody() {
        List<byte[]> oldContent = this._content;
        int totalSize = 0;
        for (byte[] fragment : oldContent) {
            totalSize += fragment.length;
        }
        byte[] body = new byte[totalSize];
        int offset = 0;
        for (byte[] fragment : oldContent) {
            System.arraycopy(fragment, 0, body, offset, fragment.length);
            offset += fragment.length;
        }
        this.setContentBody(body);
        return body;
    }

    public Assembler getFreshAssembler() {
        return new Assembler();
    }

    public void transmit(AMQChannel channel) throws IOException {
        int channelNumber = channel.getChannelNumber();
        AMQConnection connection = channel.getAMQConnection();
        Frame frame = new Frame(1, channelNumber);
        DataOutputStream bodyOut = frame.getOutputStream();
        bodyOut.writeShort(this._method.protocolClassId());
        bodyOut.writeShort(this._method.protocolMethodId());
        MethodArgumentWriter argWriter = new MethodArgumentWriter(bodyOut);
        this._method.writeArgumentsTo(argWriter);
        argWriter.flush();
        connection.writeFrame(frame);
        if (this._method.hasContent()) {
            byte[] body = this.getContentBody();
            frame = new Frame(2, channelNumber);
            bodyOut = frame.getOutputStream();
            bodyOut.writeShort(this._contentHeader.getClassId());
            this._contentHeader.writeTo(bodyOut, body.length);
            connection.writeFrame(frame);
            int frameMax = connection.getFrameMax();
            int bodyPayloadMax = frameMax == 0 ? body.length : frameMax - 8;
            for (int offset = 0; offset < body.length; offset += bodyPayloadMax) {
                int remaining = body.length - offset;
                frame = new Frame(3, channelNumber);
                bodyOut = frame.getOutputStream();
                bodyOut.write(body, offset, remaining < bodyPayloadMax ? remaining : bodyPayloadMax);
                connection.writeFrame(frame);
            }
        }
    }

    public String toString() {
        String contentStr;
        byte[] body = this.getContentBody();
        try {
            contentStr = "\"" + new String(body) + "\"";
        }
        catch (Exception e) {
            contentStr = "|" + body.length + "|";
        }
        return "{" + this._method + "," + this._contentHeader + "," + contentStr + "}";
    }

    public static void checkEmptyContentBodyFrameSize() {
        Frame f = new Frame(3, 0, new byte[0]);
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        try {
            f.writeTo(new DataOutputStream(s));
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)"IOException while checking EMPTY_CONTENT_BODY_FRAME_SIZE");
        }
        int actualLength = s.toByteArray().length;
        if (8 != actualLength) {
            throw new AssertionError((Object)("Internal error: EMPTY_CONTENT_BODY_FRAME_SIZE is incorrect - defined as 8, where the computed value is in fact " + actualLength));
        }
    }

    public class Assembler {
        public static final int STATE_EXPECTING_METHOD = 0;
        public static final int STATE_EXPECTING_CONTENT_HEADER = 1;
        public static final int STATE_EXPECTING_CONTENT_BODY = 2;
        public static final int STATE_COMPLETE = 3;
        public int state = 0;
        public long remainingBodyBytes = 0L;

        public AMQCommand completedCommand() {
            return this.state == 3 ? AMQCommand.this : null;
        }

        public void updateContentBodyState() {
            this.state = this.remainingBodyBytes > 0L ? 2 : 3;
        }

        public AMQCommand handleFrame(Frame f) throws IOException {
            switch (this.state) {
                case 0: {
                    switch (f.type) {
                        case 1: {
                            AMQCommand.this._method = AMQImpl.readMethodFrom(f.getInputStream());
                            this.state = AMQCommand.this._method.hasContent() ? 1 : 3;
                            return this.completedCommand();
                        }
                    }
                    throw new UnexpectedFrameError(f);
                }
                case 1: {
                    switch (f.type) {
                        case 2: {
                            DataInputStream in = f.getInputStream();
                            AMQCommand.this._contentHeader = AMQImpl.readContentHeaderFrom(in);
                            this.remainingBodyBytes = AMQCommand.this._contentHeader.readFrom(in);
                            this.updateContentBodyState();
                            return this.completedCommand();
                        }
                    }
                    throw new UnexpectedFrameError(f);
                }
                case 2: {
                    switch (f.type) {
                        case 3: {
                            byte[] fragment = f.getPayload();
                            this.remainingBodyBytes -= (long)fragment.length;
                            this.updateContentBodyState();
                            if (this.remainingBodyBytes < 0L) {
                                throw new UnsupportedOperationException("%%%%%% FIXME unimplemented");
                            }
                            AMQCommand.this._content.add(fragment);
                            return this.completedCommand();
                        }
                    }
                    throw new UnexpectedFrameError(f);
                }
            }
            throw new AssertionError((Object)("Bad Command State " + this.state));
        }
    }
}

