/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.impl.LongString;
import com.rabbitmq.client.impl.MethodArgumentReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentHeaderPropertyReader {
    private final DataInputStream in;
    public int[] flags;
    int argumentIndex;

    public ContentHeaderPropertyReader(DataInputStream in) throws IOException {
        this.in = in;
        this.readFlags();
        this.argumentIndex = 0;
    }

    public void readFlags() throws IOException {
        short flagsWord;
        ArrayList<Integer> acc = new ArrayList<Integer>();
        do {
            flagsWord = this.in.readShort();
            acc.add(Integer.valueOf(flagsWord));
        } while ((flagsWord & 1) != 0);
        this.flags = new int[acc.size()];
        for (int i = 0; i < this.flags.length; ++i) {
            this.flags[i] = (Integer)acc.get(i);
        }
    }

    private boolean argPresent() {
        int word = this.argumentIndex / 15;
        int bit = 15 - this.argumentIndex % 15;
        ++this.argumentIndex;
        return (this.flags[word] & 1 << bit) != 0;
    }

    public String readShortstr() throws IOException {
        if (!this.argPresent()) {
            return null;
        }
        return MethodArgumentReader.readShortstr(this.in);
    }

    public LongString readLongstr() throws IOException {
        if (!this.argPresent()) {
            return null;
        }
        return MethodArgumentReader.readLongstr(this.in);
    }

    public Integer readShort() throws IOException {
        if (!this.argPresent()) {
            return null;
        }
        return new Integer(this.in.readUnsignedShort());
    }

    public Integer readLong() throws IOException {
        if (!this.argPresent()) {
            return null;
        }
        return this.in.readInt();
    }

    public Long readLonglong() throws IOException {
        if (!this.argPresent()) {
            return null;
        }
        return new Long(this.in.readLong());
    }

    public Boolean readBit() {
        return this.argPresent() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Map<String, Object> readTable() throws IOException {
        if (!this.argPresent()) {
            return null;
        }
        return MethodArgumentReader.readTable(this.in);
    }

    public Integer readOctet() throws IOException {
        if (!this.argPresent()) {
            return null;
        }
        return this.in.readUnsignedByte();
    }

    public Date readTimestamp() throws IOException {
        if (!this.argPresent()) {
            return null;
        }
        return MethodArgumentReader.readTimestamp(this.in);
    }
}

