/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.LongString;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentHeaderPropertyWriter {
    public List<Integer> flags = new ArrayList<Integer>();
    public ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
    public DataOutputStream out = new DataOutputStream(this.outBytes);
    public int flagWord = 0;
    public int bitCount = 0;

    public void dumpTo(DataOutputStream stream) throws IOException {
        if (this.bitCount > 0) {
            this.flags.add(this.flagWord);
        }
        for (int w : this.flags) {
            stream.writeShort(w);
        }
        this.out.flush();
        stream.write(this.outBytes.toByteArray());
    }

    public boolean argPresent(Object value) {
        if (this.bitCount == 15) {
            this.flags.add(this.flagWord | 1);
            this.flagWord = 0;
            this.bitCount = 0;
        }
        if (value != null) {
            int bit = 15 - this.bitCount;
            this.flagWord |= 1 << bit;
            ++this.bitCount;
            return true;
        }
        ++this.bitCount;
        return false;
    }

    public void writeShortstr(String x) throws IOException {
        if (this.argPresent(x)) {
            this._writeShortstr(x);
        }
    }

    public void writeLongstr(String x) throws IOException {
        if (this.argPresent(x)) {
            this._writeLongstr(x);
        }
    }

    public void writeLongstr(LongString x) throws IOException {
        if (this.argPresent(x)) {
            this._writeLongstr(x);
        }
    }

    public void writeShort(Integer x) throws IOException {
        if (this.argPresent(x)) {
            this._writeShort(x);
        }
    }

    public void writeLong(Integer x) throws IOException {
        if (this.argPresent(x)) {
            this._writeLong(x);
        }
    }

    public void writeLonglong(Long x) throws IOException {
        if (this.argPresent(x)) {
            this._writeLonglong(x);
        }
    }

    public void writeTable(Map<String, Object> x) throws IOException {
        if (this.argPresent(x)) {
            this._writeTable(x);
        }
    }

    public void writeOctet(Integer x) throws IOException {
        if (this.argPresent(x)) {
            this._writeOctet(x);
        }
    }

    public void writeTimestamp(Date x) throws IOException {
        if (this.argPresent(x)) {
            this._writeTimestamp(x);
        }
    }

    public void _writeShortstr(String str) throws IOException {
        byte[] bytes = str.getBytes("utf-8");
        this.out.writeByte(bytes.length);
        this.out.write(bytes);
    }

    public void _writeLongstr(String str) throws IOException {
        byte[] bytes = str.getBytes("utf-8");
        this.out.writeInt(bytes.length);
        this.out.write(bytes);
    }

    public void _writeLongstr(LongString str) throws IOException {
        this.out.writeInt((int)str.length());
        IOUtils.copy((InputStream)str.getStream(), (OutputStream)this.out);
    }

    public void _writeShort(Integer s) throws IOException {
        this.out.writeShort(s);
    }

    public void _writeLong(Integer l) throws IOException {
        this.out.writeInt(l);
    }

    public void _writeLonglong(Long ll) throws IOException {
        this.out.writeLong(ll);
    }

    public void _writeTable(Map<String, Object> table) throws IOException {
        this.out.writeInt((int)Frame.tableSize(table));
        for (Map.Entry<String, Object> entry : table.entrySet()) {
            this._writeShortstr(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof String) {
                this.out.writeByte(83);
                this._writeLongstr((String)value);
                continue;
            }
            if (value instanceof LongString) {
                this.out.writeByte(83);
                this._writeLongstr((LongString)value);
                continue;
            }
            if (value instanceof Integer) {
                this.out.writeByte(73);
                this._writeLong((Integer)value);
                continue;
            }
            if (value instanceof BigDecimal) {
                this.out.writeByte(68);
                BigDecimal decimal = (BigDecimal)value;
                this.out.writeByte(decimal.scale());
                BigInteger unscaled = decimal.unscaledValue();
                if (unscaled.bitLength() > 32) {
                    throw new IllegalArgumentException("BigDecimal too large to be encoded");
                }
                this.out.writeInt(decimal.unscaledValue().intValue());
                continue;
            }
            if (value instanceof Date) {
                this.out.writeByte(84);
                this._writeTimestamp((Date)value);
                continue;
            }
            if (value instanceof Map) {
                this.out.writeByte(70);
                this._writeTable((Map)value);
                continue;
            }
            throw new IllegalArgumentException("Invalid value type: " + value.getClass().getName() + " for key " + entry.getKey());
        }
    }

    public void _writeOctet(Integer octet) throws IOException {
        this.out.writeByte(octet);
    }

    public void _writeTimestamp(Date timestamp) throws IOException {
        this.out.writeLong(timestamp.getTime() / 1000L);
    }

    public void writeBit(Boolean b) {
        if (b == null) {
            throw new IllegalArgumentException("Null bit illegal in ContentHeaderPropertyWriter.writeBit");
        }
        this.argPresent(b != false ? b : null);
    }
}

