/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.MalformedFrameException;
import com.rabbitmq.client.impl.LongString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frame {
    public int type;
    public int channel;
    public byte[] payload;
    public ByteArrayOutputStream accumulator;

    public Frame() {
    }

    public Frame(int type, int channel) {
        this.type = type;
        this.channel = channel;
        this.payload = null;
        this.accumulator = new ByteArrayOutputStream();
    }

    public Frame(int type, int channel, byte[] payload) {
        this.type = type;
        this.channel = channel;
        this.payload = payload;
        this.accumulator = null;
    }

    public static Frame readFrom(DataInputStream is) throws IOException {
        int type;
        try {
            type = is.readUnsignedByte();
        }
        catch (SocketTimeoutException ste) {
            return null;
        }
        if (type == 65) {
            Frame.protocolVersionMismatch(is);
        }
        int channel = is.readUnsignedShort();
        int payloadSize = is.readInt();
        byte[] payload = new byte[payloadSize];
        is.readFully(payload);
        int frameEndMarker = is.readUnsignedByte();
        if (frameEndMarker != 206) {
            throw new MalformedFrameException("Bad frame end marker: " + frameEndMarker);
        }
        return new Frame(type, channel, payload);
    }

    public static void protocolVersionMismatch(DataInputStream is) throws IOException {
        MalformedFrameException x;
        byte[] expectedBytes;
        for (byte expectedByte : expectedBytes = new byte[]{77, 81, 80}) {
            int nextByte = is.readUnsignedByte();
            if (nextByte == expectedByte) continue;
            throw new MalformedFrameException("Invalid AMQP protocol header from server: expected character " + expectedByte + ", got " + nextByte);
        }
        try {
            int transportHigh = is.readUnsignedByte();
            int transportLow = is.readUnsignedByte();
            int serverMajor = is.readUnsignedByte();
            int serverMinor = is.readUnsignedByte();
            x = new MalformedFrameException("AMQP protocol version mismatch; we are version 8-0, server is " + serverMajor + "-" + serverMinor + " with transport " + transportHigh + "." + transportLow);
        }
        catch (IOException ex) {
            x = new MalformedFrameException("Invalid AMQP protocol header from server");
        }
        throw x;
    }

    public void finishWriting() {
        if (this.accumulator != null) {
            this.payload = this.accumulator.toByteArray();
            this.accumulator = null;
        }
    }

    public void writeTo(DataOutputStream os) throws IOException {
        this.finishWriting();
        os.writeByte(this.type);
        os.writeShort(this.channel);
        os.writeInt(this.payload.length);
        os.write(this.payload);
        os.write(206);
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public DataInputStream getInputStream() {
        return new DataInputStream(new ByteArrayInputStream(this.payload));
    }

    public DataOutputStream getOutputStream() {
        return new DataOutputStream(this.accumulator);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Frame(" + this.type + ", " + this.channel + ", ");
        if (this.accumulator == null) {
            sb.append(this.payload.length + " bytes of payload");
        } else {
            sb.append(this.accumulator.size() + " bytes of accumulator");
        }
        sb.append(")");
        return sb.toString();
    }

    public static Map<String, Object> buildTable(Object[] keysValues) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int index = 0; index < keysValues.length; index += 2) {
            String key = (String)keysValues[index];
            Object value = keysValues[index + 1];
            result.put(key, value);
        }
        return result;
    }

    public static long tableSize(Map<String, Object> table) throws UnsupportedEncodingException {
        long acc = 0L;
        for (Map.Entry<String, Object> entry : table.entrySet()) {
            acc += (long)Frame.shortStrSize(entry.getKey());
            ++acc;
            Object value = entry.getValue();
            if (value instanceof String) {
                acc += (long)Frame.longStrSize((String)entry.getValue());
                continue;
            }
            if (value instanceof LongString) {
                acc += 4L;
                acc += ((LongString)value).length();
                continue;
            }
            if (value instanceof Integer) {
                acc += 4L;
                continue;
            }
            if (value instanceof BigDecimal) {
                acc += 5L;
                continue;
            }
            if (value instanceof Date || value instanceof Timestamp) {
                acc += 8L;
                continue;
            }
            if (value instanceof Map) {
                acc += 4L;
                acc += Frame.tableSize((Map)value);
                continue;
            }
            throw new IllegalArgumentException("invalid value in table");
        }
        return acc;
    }

    public static int longStrSize(String str) throws UnsupportedEncodingException {
        return str.getBytes("utf-8").length + 4;
    }

    public static int shortStrSize(String str) throws UnsupportedEncodingException {
        return str.getBytes("utf-8").length + 1;
    }
}

