/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.FrameHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

public class SocketFrameHandler
implements FrameHandler {
    public final String _host;
    public final int _port;
    public final Socket _socket;
    public final DataInputStream _inputStream;
    public final DataOutputStream _outputStream;

    public SocketFrameHandler(String hostName, int portNumber) throws IOException {
        this._host = hostName;
        this._port = portNumber;
        this._socket = new Socket(this._host, this._port);
        this._inputStream = new DataInputStream(this._socket.getInputStream());
        this._outputStream = new DataOutputStream(this._socket.getOutputStream());
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public void setTimeout(int timeoutMs) throws SocketException {
        this._socket.setSoTimeout(timeoutMs);
    }

    public int getTimeout() throws SocketException {
        return this._socket.getSoTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHeader(int major, int minor) throws IOException {
        DataOutputStream dataOutputStream = this._outputStream;
        synchronized (dataOutputStream) {
            this._outputStream.write("AMQP".getBytes("US-ASCII"));
            this._outputStream.write(1);
            this._outputStream.write(1);
            this._outputStream.write(major);
            this._outputStream.write(minor);
        }
    }

    public void sendHeader() throws IOException {
        this.sendHeader(8, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame readFrame() throws IOException {
        DataInputStream dataInputStream = this._inputStream;
        synchronized (dataInputStream) {
            return Frame.readFrom(this._inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFrame(Frame frame) throws IOException {
        DataOutputStream dataOutputStream = this._outputStream;
        synchronized (dataOutputStream) {
            frame.writeTo(this._outputStream);
        }
    }

    public void close() {
        try {
            this._socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

