/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools;

import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.utility.BlockingCell;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class Tracer
implements Runnable {
    public Socket inSock;
    public Socket outSock;
    public int id;
    public DataInputStream iis;
    public DataOutputStream ios;
    public DataInputStream ois;
    public DataOutputStream oos;

    public static void main(String[] args) {
        int listenPort = args.length > 0 ? Integer.parseInt(args[0]) : 5673;
        String connectHost = args.length > 1 ? args[1] : "localhost";
        int connectPort = args.length > 2 ? Integer.parseInt(args[2]) : 5672;
        System.out.println("Usage: Tracer [<listenport> [<connecthost> [<connectport>]]]");
        System.out.println("Invoked as: Tracer " + listenPort + " " + connectHost + " " + connectPort);
        try {
            ServerSocket server = new ServerSocket(listenPort);
            int counter = 0;
            while (true) {
                Socket conn = server.accept();
                ++counter;
                new Tracer(conn, counter, connectHost, connectPort);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(1);
            return;
        }
    }

    public Tracer(Socket sock, int id, String host, int port) throws IOException {
        this.inSock = sock;
        this.outSock = new Socket(host, port);
        this.id = id;
        this.iis = new DataInputStream(this.inSock.getInputStream());
        this.ios = new DataOutputStream(this.inSock.getOutputStream());
        this.ois = new DataInputStream(this.outSock.getInputStream());
        this.oos = new DataOutputStream(this.outSock.getOutputStream());
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            byte[] handshake = new byte[8];
            this.iis.readFully(handshake);
            this.oos.write(handshake);
            BlockingCell<Object> w = new BlockingCell<Object>();
            DirectionHandler inHandler = new DirectionHandler(w, true, this.iis, this.oos);
            DirectionHandler outHandler = new DirectionHandler(w, false, this.ois, this.ios);
            new Thread(inHandler).start();
            new Thread(outHandler).start();
            Object result = w.uninterruptibleGet();
            if (result instanceof Exception) {
                ((Exception)result).printStackTrace();
            }
        }
        catch (EOFException eofe) {
            eofe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                this.inSock.close();
                this.outSock.close();
            }
            catch (IOException ioe2) {
                ioe2.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DirectionHandler
    implements Runnable {
        public BlockingCell<Object> waitCell;
        public boolean inBound;
        public DataInputStream i;
        public DataOutputStream o;
        public AMQCommand.Assembler c;

        public DirectionHandler(BlockingCell<Object> waitCell, boolean inBound, DataInputStream i, DataOutputStream o) {
            this.waitCell = waitCell;
            this.inBound = inBound;
            this.i = i;
            this.o = o;
            this.c = AMQCommand.newAssembler();
        }

        public Frame readFrame() throws IOException {
            return Frame.readFrom(this.i);
        }

        public void report(int channel, Object object) {
            System.out.println("conn#" + Tracer.this.id + " ch#" + channel + (this.inBound ? " -> " : " <- ") + object);
        }

        public void doFrame() throws IOException {
            Frame f = this.readFrame();
            if (f != null) {
                f.writeTo(this.o);
                if (f.type == 8) {
                    this.report(f.channel, f);
                } else {
                    AMQCommand cmd = this.c.handleFrame(f);
                    if (cmd != null) {
                        this.report(f.channel, cmd);
                        this.c = AMQCommand.newAssembler();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        this.doFrame();
                    }
                }
                catch (Exception e) {
                    this.waitCell.setIfUnset(e);
                    this.waitCell.setIfUnset(new Object());
                }
            }
            catch (Throwable throwable) {
                this.waitCell.setIfUnset(new Object());
                throw throwable;
            }
        }
    }
}

