/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.api;

import com.redhat.devtools.alizer.api.Component;
import com.redhat.devtools.alizer.api.ComponentRecognizer;
import com.redhat.devtools.alizer.api.Language;
import com.redhat.devtools.alizer.api.LanguageFileHandler;
import com.redhat.devtools.alizer.api.LanguageFileItem;
import com.redhat.devtools.alizer.api.LanguageRecognizer;
import com.redhat.devtools.alizer.api.Recognizer;
import com.redhat.devtools.alizer.api.RecognizerFactory;
import com.redhat.devtools.alizer.api.spi.LanguageEnricherProvider;
import com.redhat.devtools.alizer.api.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class ComponentRecognizerImpl
extends Recognizer
implements ComponentRecognizer {
    public ComponentRecognizerImpl(RecognizerFactory builder) {
        super(builder);
    }

    @Override
    public List<Component> analyze(String path) throws IOException {
        List<File> files = this.getFiles(Paths.get(path, new String[0]));
        List<Component> components = this.detectComponents(files);
        List<Path> directoriesPathsWithoutConfigFile = this.getDirectoriesPathsWithoutConfigFile(Paths.get(path, new String[0]), components);
        components.addAll(this.getComponentsWithoutConfigFile(directoriesPathsWithoutConfigFile));
        return components;
    }

    private List<Path> getDirectoriesPathsWithoutConfigFile(Path root, List<Component> components) throws IOException {
        if (components.isEmpty()) {
            return Collections.singletonList(root);
        }
        AtomicReference directoriesWithoutConfigFile = new AtomicReference(new ArrayList());
        Files.walk(root, Integer.MAX_VALUE, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).skip(1L).forEach(directory -> {
            if (!this.hasDirectoryAnyComponent((Path)directory, components)) {
                directoriesWithoutConfigFile.set(this.getParentFolders((Path)directory, (List)directoriesWithoutConfigFile.get()));
            }
        });
        return directoriesWithoutConfigFile.get();
    }

    private boolean hasDirectoryAnyComponent(Path directory, List<Component> components) {
        return components.stream().map(Component::getPath).anyMatch(directoryWithComponent -> directoryWithComponent.equals(directory) || this.isFirstPathParentOfSecond((Path)directoryWithComponent, directory));
    }

    private List<Component> getComponentsWithoutConfigFile(List<Path> directories) throws IOException {
        ArrayList<Component> components = new ArrayList<Component>();
        for (Path directory : directories) {
            Component component = this.detectComponent(directory, "");
            if (component == null || !this.isValidNoConfigComponent(component)) continue;
            components.add(component);
        }
        return components;
    }

    private boolean isValidNoConfigComponent(Component component) {
        if (component.getLanguages().isEmpty()) {
            return false;
        }
        String language = component.getLanguages().get(0).getName();
        LanguageFileItem languageFileItem = LanguageFileHandler.get().getLanguageByNameOrAlias(language);
        return languageFileItem.getConfigurationFiles().isEmpty();
    }

    private List<Component> detectComponents(List<File> files) throws IOException {
        Map<String, String> configurationPerLanguage = LanguageFileHandler.get().getConfigurationPerLanguageMapping();
        ArrayList<Component> components = new ArrayList<Component>();
        for (File file : files) {
            Component component;
            if (!configurationPerLanguage.containsKey(file.getName()) || !this.isConfigurationValid(configurationPerLanguage.get(file.getName()), file) || (component = this.detectComponent(file.getParentFile().toPath(), configurationPerLanguage.get(file.getName()))) == null) continue;
            components.add(component);
        }
        return components;
    }

    private boolean isConfigurationValid(String language, File file) {
        LanguageEnricherProvider enricher = Utils.getEnricherByLanguage(language);
        if (enricher != null) {
            return enricher.create().isConfigurationValidForComponent(language, file);
        }
        return false;
    }

    private Component detectComponent(Path root, String configurationLanguage) throws IOException {
        RecognizerFactory recognizerFactory = new RecognizerFactory();
        LanguageRecognizer languageRecognizer = recognizerFactory.createLanguageRecognizer();
        List<Language> languages = this.getLanguagesWeightedByConfigFile(languageRecognizer.analyze(root.toString()), configurationLanguage);
        if (this.isLanguageSupported(languages)) {
            return new Component(root, languages);
        }
        return null;
    }

    private boolean isLanguageSupported(List<Language> languages) {
        if (languages.isEmpty()) {
            return false;
        }
        Language mainLanguage = languages.get(0);
        return mainLanguage.canBeComponent() && !mainLanguage.getFrameworks().isEmpty();
    }

    private List<Language> getLanguagesWeightedByConfigFile(List<Language> languages, String configurationLanguage) {
        if (configurationLanguage.isEmpty()) {
            return languages;
        }
        Optional<Language> language = languages.stream().filter(lang -> lang.getName().equalsIgnoreCase(configurationLanguage)).findFirst();
        if (language.isPresent()) {
            languages.remove(language.get());
            languages.add(0, language.get());
        }
        return languages;
    }

    private boolean isFirstPathParentOfSecond(Path path, Path potentialSubFolder) {
        return this.isIncludedInPath(potentialSubFolder, path::equals);
    }

    private boolean isIncludedInPath(Path path, Function<Path, Boolean> isIncluded) {
        boolean containSubFolder = false;
        while (path != null && !containSubFolder) {
            if (isIncluded.apply(path).booleanValue()) {
                containSubFolder = true;
            }
            path = path.getParent();
        }
        return containSubFolder;
    }

    private List<Path> getParentFolders(Path target, List<Path> directories) {
        ArrayList<Path> support = new ArrayList<Path>();
        for (Path directory : directories) {
            Path newPath = this.getParentFolder(target, directory);
            if (newPath != null) {
                target = newPath;
                continue;
            }
            support.add(directory);
        }
        support.add(target);
        return support;
    }

    private Path getParentFolder(Path directory1, Path directory2) {
        if (directory1.toString().length() > directory2.toString().length()) {
            if (this.isFirstPathParentOfSecond(directory2, directory1)) {
                return directory2;
            }
        } else if (this.isFirstPathParentOfSecond(directory1, directory2)) {
            return directory1;
        }
        return null;
    }
}

