/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.api;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.redhat.devtools.alizer.api.LanguageFileItem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageFileHandler {
    private static final Logger logger = LoggerFactory.getLogger(LanguageFileHandler.class);
    private static final String LANGUAGES_YAML_PATH = "languages.yml";
    private static final String LANGUAGES_CUSTOMIZATION_YAML_PATH = "languages-customization.yml";
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static LanguageFileHandler INSTANCE;
    private Map<String, LanguageFileItem> languages = new HashMap<String, LanguageFileItem>();
    private Map<String, List<LanguageFileItem>> extensionXLanguage = new HashMap<String, List<LanguageFileItem>>();

    private LanguageFileHandler() {
        this.initLanguages();
    }

    public static LanguageFileHandler get() {
        if (INSTANCE == null) {
            INSTANCE = new LanguageFileHandler();
        }
        return INSTANCE;
    }

    private void initLanguages() {
        try {
            String yamlAsString = IOUtils.toString((InputStream)LanguageFileHandler.class.getResourceAsStream("/languages.yml"), (Charset)Charset.defaultCharset());
            JsonNode node = YAML_MAPPER.readTree(yamlAsString);
            Iterator it = node.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String nameLanguage = (String)entry.getKey();
                JsonNode languageAttributes = (JsonNode)entry.getValue();
                String type = languageAttributes.get("type").asText();
                String group = languageAttributes.has("group") ? languageAttributes.get("group").asText() : "";
                List<String> aliases = this.getValueAsList(languageAttributes, "aliases");
                LanguageFileItem languageFileItem = new LanguageFileItem(nameLanguage, aliases, type, group);
                this.languages.put(nameLanguage, languageFileItem);
                this.populateLanguageList(this.extensionXLanguage, languageAttributes, "extensions", languageFileItem);
            }
            this.customizeLanguages();
        }
        catch (IOException e) {
            logger.warn(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void customizeLanguages() {
        try {
            String yamlAsString = IOUtils.toString((InputStream)LanguageFileHandler.class.getResourceAsStream("/languages-customization.yml"), (Charset)Charset.defaultCharset());
            JsonNode node = YAML_MAPPER.readTree(yamlAsString);
            Iterator it = node.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String nameLanguage = (String)entry.getKey();
                LanguageFileItem languageFileItem = this.languages.get(nameLanguage);
                if (languageFileItem == null) continue;
                JsonNode languageAttributes = (JsonNode)entry.getValue();
                List<String> configurationFiles = this.getValueAsList(languageAttributes, "configuration_files");
                List<String> excludeFolders = this.getValueAsList(languageAttributes, "exclude_folders");
                boolean canBeComponent = languageAttributes.has("component") && languageAttributes.get("component").asBoolean();
                languageFileItem.setConfigurationFiles(configurationFiles);
                languageFileItem.setExcludeFolders(excludeFolders);
                languageFileItem.setCanBeComponent(canBeComponent);
                this.languages.put(nameLanguage, languageFileItem);
            }
        }
        catch (IOException e) {
            logger.warn(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private List<String> getValueAsList(JsonNode languageAttributes, String field) {
        ArrayList<String> values = new ArrayList<String>();
        if (languageAttributes.has(field)) {
            JsonNode fieldValues = languageAttributes.get(field);
            for (JsonNode node : fieldValues) {
                values.add(node.asText());
            }
        }
        return values;
    }

    private void populateLanguageList(Map<String, List<LanguageFileItem>> languageMap, JsonNode languageAttributes, String field, LanguageFileItem language) {
        if (languageAttributes.has(field)) {
            JsonNode fieldValues = languageAttributes.get(field);
            for (JsonNode value : fieldValues) {
                if (value.asText("").isEmpty()) continue;
                List languageMapValue = languageMap.getOrDefault(value.asText(), new ArrayList());
                languageMapValue.add(language);
                languageMap.put(value.asText(), languageMapValue);
            }
        }
    }

    public List<LanguageFileItem> getLanguagesByExtension(String extension) {
        return this.extensionXLanguage.getOrDefault(extension, Collections.emptyList());
    }

    public LanguageFileItem getLanguageByName(String name) {
        Optional<LanguageFileItem> languageFileItem = this.languages.entrySet().stream().filter(item -> ((String)item.getKey()).equalsIgnoreCase(name)).map(Map.Entry::getValue).findFirst();
        return languageFileItem.orElse(null);
    }

    public LanguageFileItem getLanguageByNameOrAlias(String name) {
        LanguageFileItem languageFileItem = this.getLanguageByName(name);
        if (languageFileItem == null) {
            return this.getLanguageByAlias(name);
        }
        return languageFileItem;
    }

    public LanguageFileItem getLanguageByAlias(String alias) {
        String finalAlias = alias.toLowerCase();
        Optional<LanguageFileItem> languageFileItem = this.languages.values().stream().filter(item -> item.getAliases().contains(finalAlias)).findFirst();
        return languageFileItem.orElse(null);
    }

    public Map<String, String> getConfigurationPerLanguageMapping() {
        HashMap<String, String> configurationPerLanguage = new HashMap<String, String>();
        for (LanguageFileItem fileItem : this.languages.values()) {
            List<String> configurationFiles = fileItem.getConfigurationFiles();
            if (configurationFiles.isEmpty()) continue;
            for (String configFile : configurationFiles) {
                configurationPerLanguage.put(configFile, fileItem.getName());
            }
        }
        return configurationPerLanguage;
    }
}

