/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.api;

import com.redhat.devtools.alizer.api.DevfileType;
import com.redhat.devtools.alizer.api.Language;
import com.redhat.devtools.alizer.api.LanguageFileHandler;
import com.redhat.devtools.alizer.api.LanguageFileItem;
import com.redhat.devtools.alizer.api.LanguageRecognizer;
import com.redhat.devtools.alizer.api.LanguageScore;
import com.redhat.devtools.alizer.api.Recognizer;
import com.redhat.devtools.alizer.api.RecognizerFactory;
import com.redhat.devtools.alizer.api.spi.LanguageEnricherProvider;
import com.redhat.devtools.alizer.api.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageRecognizerImpl
extends Recognizer
implements LanguageRecognizer {
    private static final Logger logger = LoggerFactory.getLogger(LanguageRecognizerImpl.class);

    LanguageRecognizerImpl(RecognizerFactory builder) {
        super(builder);
    }

    @Override
    public <T extends DevfileType> T selectDevFileFromTypes(String srcPath, List<T> devfileTypes) throws IOException {
        List<Language> languages = this.analyze(srcPath);
        return this.selectDevFileFromTypes(languages, devfileTypes);
    }

    @Override
    public <T extends DevfileType> T selectDevFileFromTypes(List<Language> languages, List<T> devfileTypes) {
        for (Language language : languages) {
            Optional<LanguageScore> score = devfileTypes.stream().map(devfileType -> new LanguageScore(language, (DevfileType)devfileType)).sorted().findFirst();
            if (!score.isPresent() || score.get().getScore() <= 0) continue;
            return (T)score.get().getDevfileType();
        }
        return null;
    }

    @Override
    public List<Language> analyze(String path) throws IOException {
        HashMap languagesDetected = new HashMap();
        LanguageFileHandler handler = LanguageFileHandler.get();
        List<File> files = this.getFiles(Paths.get(path, new String[0]));
        Map<String, Long> extensions = files.stream().collect(Collectors.groupingBy(file -> "." + FilenameUtils.getExtension((String)file.getName()), Collectors.counting()));
        extensions.keySet().forEach(extension -> {
            List<LanguageFileItem> languages = handler.getLanguagesByExtension((String)extension);
            if (languages.isEmpty()) {
                return;
            }
            languages.forEach(language -> {
                LanguageFileItem tmpLanguage = language.getGroup().isEmpty() ? language : handler.getLanguageByName(language.getGroup());
                long percentage = (long)languagesDetected.getOrDefault(tmpLanguage, 0).intValue() + (Long)extensions.get(extension);
                languagesDetected.put(tmpLanguage, (int)percentage);
            });
        });
        int totalProgrammingOccurences = (int)languagesDetected.keySet().stream().filter(lang -> lang.getType().equalsIgnoreCase("programming")).mapToLong(languagesDetected::get).sum();
        return languagesDetected.keySet().stream().filter(lang -> lang.getType().equalsIgnoreCase("programming")).filter(lang -> (double)((Integer)languagesDetected.get(lang)).intValue() / (double)totalProgrammingOccurences > 0.02).map(lang -> new Language(lang.getName(), lang.getAliases(), (double)((Integer)languagesDetected.get(lang)).intValue() / (double)totalProgrammingOccurences * 100.0, lang.canBeComponent())).map(lang -> this.getDetailedLanguage((Language)lang, files)).sorted(Comparator.comparingDouble(Language::getUsageInPercentage).reversed()).collect(Collectors.toList());
    }

    private Language getDetailedLanguage(Language language, List<File> files) {
        LanguageEnricherProvider enricher = Utils.getEnricherByLanguage(language.getName());
        if (enricher != null) {
            try {
                return enricher.create().getEnrichedLanguage(language, files);
            }
            catch (IOException e) {
                logger.warn(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return language;
    }
}

