/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.api.spi;

import com.redhat.devtools.alizer.api.Language;
import com.redhat.devtools.alizer.api.spi.LanguageEnricherProvider;
import com.redhat.devtools.alizer.api.spi.framework.FrameworkDetectorProvider;
import com.redhat.devtools.alizer.api.spi.framework.nodejs.NodeJsFrameworkDetectorProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;

public class JavaScriptLanguageEnricherProviderImpl
extends LanguageEnricherProvider {
    @Override
    public LanguageEnricherProvider create() {
        return new JavaScriptLanguageEnricherProviderImpl();
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Arrays.asList("JAVASCRIPT", "TYPESCRIPT");
    }

    @Override
    public Language getEnrichedLanguage(Language language, List<File> files) throws IOException {
        Optional<File> packageJson = files.stream().filter(file -> file.getName().equalsIgnoreCase("package.json")).findFirst();
        if (packageJson.isPresent()) {
            language.setTools(Arrays.asList("nodejs"));
            language.setFrameworks(this.getFrameworks(packageJson.get()));
        }
        return language;
    }

    private List<String> getFrameworks(File file) throws IOException {
        ArrayList<String> frameworks = new ArrayList<String>();
        ServiceLoader<FrameworkDetectorProvider> loader = ServiceLoader.load(FrameworkDetectorProvider.class, JavaScriptLanguageEnricherProviderImpl.class.getClassLoader());
        for (FrameworkDetectorProvider provider : loader) {
            NodeJsFrameworkDetectorProvider configProvider;
            if (!(provider instanceof NodeJsFrameworkDetectorProvider) || !(configProvider = (NodeJsFrameworkDetectorProvider)provider.create()).hasFramework(file)) continue;
            frameworks.addAll(configProvider.getFrameworks());
        }
        return frameworks;
    }
}

