/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.api.spi;

import com.redhat.devtools.alizer.api.Language;
import com.redhat.devtools.alizer.api.LanguageFileHandler;
import com.redhat.devtools.alizer.api.LanguageFileItem;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;

public abstract class LanguageEnricherProvider {
    public abstract LanguageEnricherProvider create();

    public abstract List<String> getSupportedLanguages();

    public abstract Language getEnrichedLanguage(Language var1, List<File> var2) throws IOException;

    public boolean isConfigurationValidForComponent(String language, File file) {
        return this.isValidPathPerLanguage(file.toPath(), language);
    }

    private boolean isValidPathPerLanguage(Path path, String language) {
        LanguageFileItem languageFileItem = LanguageFileHandler.get().getLanguageByName(language);
        List<String> excludeFolders = languageFileItem.getExcludeFolders();
        if (excludeFolders.isEmpty()) {
            return true;
        }
        for (String excludeFolder : excludeFolders) {
            if (!this.isFolderNameIncludedInPath(path, excludeFolder)) continue;
            return false;
        }
        return true;
    }

    private boolean isFolderNameIncludedInPath(Path fullPath, String potentialSubFolderName) {
        return this.isIncludedInPath(fullPath, p -> p.toFile().isDirectory() && p.getFileName() != null && p.getFileName().toString().equalsIgnoreCase(potentialSubFolderName));
    }

    private boolean isIncludedInPath(Path path, Function<Path, Boolean> isIncluded) {
        boolean containSubFolder = false;
        while (path != null && !containSubFolder) {
            if (isIncluded.apply(path).booleanValue()) {
                containSubFolder = true;
            }
            path = path.getParent();
        }
        return containSubFolder;
    }
}

