/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.api.spi;

import com.redhat.devtools.alizer.api.Language;
import com.redhat.devtools.alizer.api.spi.LanguageEnricherProvider;
import com.redhat.devtools.alizer.api.spi.framework.FrameworkDetectorProvider;
import com.redhat.devtools.alizer.api.spi.framework.FrameworkDetectorWithoutConfigFileProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;

public class PythonLanguageEnricherProviderImpl
extends LanguageEnricherProvider {
    @Override
    public LanguageEnricherProvider create() {
        return new PythonLanguageEnricherProviderImpl();
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Arrays.asList("PYTHON");
    }

    @Override
    public Language getEnrichedLanguage(Language language, List<File> files) throws IOException {
        language.setFrameworks(this.getFrameworks(files));
        return language;
    }

    private List<String> getFrameworks(List<File> files) throws IOException {
        ArrayList<String> frameworks = new ArrayList<String>();
        ServiceLoader<FrameworkDetectorProvider> loader = ServiceLoader.load(FrameworkDetectorProvider.class, PythonLanguageEnricherProviderImpl.class.getClassLoader());
        for (FrameworkDetectorProvider provider : loader) {
            FrameworkDetectorWithoutConfigFileProvider noConfigProvider;
            if (!(provider instanceof FrameworkDetectorWithoutConfigFileProvider) || !(noConfigProvider = (FrameworkDetectorWithoutConfigFileProvider)provider.create()).getSupportedLanguages().contains("PYTHON") || !noConfigProvider.hasFramework(files)) continue;
            frameworks.addAll(noConfigProvider.getFrameworks());
        }
        return frameworks;
    }
}

