/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.api.spi.framework.java;

import com.redhat.devtools.alizer.api.spi.framework.FrameworkDetectorWithConfigFileProvider;
import com.redhat.devtools.alizer.api.utils.DocumentParser;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class JavaFrameworkDetectorProvider
implements FrameworkDetectorWithConfigFileProvider {
    protected abstract String getFrameworkTag();

    @Override
    public List<String> getSupportedLanguages() {
        return Arrays.asList("JAVA");
    }

    @Override
    public boolean hasFramework(File file) throws IOException {
        if (file.getName().equalsIgnoreCase("build.gradle")) {
            return DocumentParser.isTagInFile(file, this.getFrameworkTag());
        }
        try {
            return this.hasGroupIdMaven(file, this.getFrameworkTag());
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected boolean hasGroupIdMaven(File file, String groupId) throws ParserConfigurationException, IOException, SAXException {
        NodeList nodeList = DocumentParser.getElementsByTag(file, "groupId");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getTextContent().startsWith(groupId)) continue;
            return true;
        }
        return false;
    }
}

