/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.api.spi.framework.python;

import com.redhat.devtools.alizer.api.spi.framework.FrameworkDetectorWithoutConfigFileProvider;
import com.redhat.devtools.alizer.api.utils.DocumentParser;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class DjangoFrameworkDetectorProviderImpl
implements FrameworkDetectorWithoutConfigFileProvider {
    private static final String DJANGO_TAG = "from django.";

    @Override
    public FrameworkDetectorWithoutConfigFileProvider create() {
        return new DjangoFrameworkDetectorProviderImpl();
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Arrays.asList("PYTHON");
    }

    @Override
    public List<String> getFrameworks() {
        return Arrays.asList("Django");
    }

    @Override
    public boolean hasFramework(List<File> files) throws IOException {
        Optional<File> manage = files.stream().filter(file -> file.getName().equalsIgnoreCase("manage.py")).findFirst();
        Optional<File> urls = files.stream().filter(file -> file.getName().equalsIgnoreCase("urls.py")).findFirst();
        Optional<File> wsgi = files.stream().filter(file -> file.getName().equalsIgnoreCase("wsgi.py")).findFirst();
        Optional<File> asgi = files.stream().filter(file -> file.getName().equalsIgnoreCase("asgi.py")).findFirst();
        boolean manageIsDjango = manage.isPresent() && DocumentParser.isTagInFile(manage.get(), DJANGO_TAG);
        boolean urlsIsDjango = urls.isPresent() && DocumentParser.isTagInFile(urls.get(), DJANGO_TAG);
        boolean wsgiIsDjango = wsgi.isPresent() && DocumentParser.isTagInFile(wsgi.get(), DJANGO_TAG);
        boolean asgiIsDjango = asgi.isPresent() && DocumentParser.isTagInFile(asgi.get(), DJANGO_TAG);
        return manageIsDjango || urlsIsDjango || wsgiIsDjango || asgiIsDjango;
    }
}

