/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class LanguageFileItem {
    private String name;
    private List<String> aliases;
    private String type;
    private String group;
    private List<String> configurationFiles;
    private List<String> excludeFolders;
    private boolean canBeComponent;
    private boolean disabled;

    public LanguageFileItem(String name, List<String> aliases, String type, String group) {
        this.name = name;
        this.aliases = aliases;
        this.type = type;
        this.group = group;
        this.configurationFiles = new ArrayList<String>();
        this.excludeFolders = new ArrayList<String>();
        this.canBeComponent = false;
        this.disabled = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void addAliases(List<String> aliasesToBeAdded) {
        if (aliasesToBeAdded.isEmpty()) {
            return;
        }
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>();
        }
        HashSet<String> aliasesAsSet = new HashSet<String>(this.aliases);
        aliasesAsSet.addAll(aliasesToBeAdded);
        this.aliases = new ArrayList<String>(aliasesAsSet);
    }

    public String getGroup() {
        return this.group;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getConfigurationFiles() {
        return this.configurationFiles;
    }

    public void setConfigurationFiles(List<String> configurationFiles) {
        this.configurationFiles = configurationFiles;
    }

    public List<String> getExcludeFolders() {
        return this.excludeFolders;
    }

    public void setExcludeFolders(List<String> excludeFolders) {
        this.excludeFolders = excludeFolders;
    }

    public boolean canBeComponent() {
        return this.canBeComponent;
    }

    public void setCanBeComponent(boolean canBeComponent) {
        this.canBeComponent = canBeComponent;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }
}

