/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.api.spi;

import com.redhat.devtools.alizer.api.Language;
import com.redhat.devtools.alizer.api.spi.LanguageEnricherProvider;
import com.redhat.devtools.alizer.api.utils.DocumentParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DotNetLanguageEnricherProviderImpl
extends LanguageEnricherProvider {
    private static final Pattern PROJ_PATTERN = Pattern.compile(".*\\.\\w+proj");

    @Override
    public LanguageEnricherProvider create() {
        return new DotNetLanguageEnricherProviderImpl();
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Arrays.asList("C#", "F#", "VISUAL BASIC .NET");
    }

    @Override
    public Language getEnrichedLanguage(Language language, List<File> files) throws IOException {
        List<File> configFiles = files.stream().filter(file -> PROJ_PATTERN.matcher(file.getName()).matches()).collect(Collectors.toList());
        if (!configFiles.isEmpty()) {
            language.setFrameworks(this.getFrameworks(configFiles));
        }
        return language;
    }

    private List<String> getFrameworks(List<File> files) throws IOException {
        ArrayList<String> frameworks = new ArrayList<String>();
        try {
            for (File file : files) {
                List<String> frameworksDetected = this.getFramework(file);
                if (frameworksDetected.isEmpty()) continue;
                frameworks.addAll(frameworksDetected);
            }
        }
        catch (ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        return frameworks;
    }

    private List<String> getFramework(File file) throws ParserConfigurationException, IOException, SAXException {
        String value;
        String framework;
        String framework2;
        Node httpRuntimeNode = DocumentParser.getElementsByTag(file, "httpRuntime").item(0);
        if (httpRuntimeNode != null && !(framework2 = this.getFrameworkAttribute(httpRuntimeNode)).isEmpty()) {
            return Collections.singletonList(framework2);
        }
        Node compilationNode = DocumentParser.getElementsByTag(file, "compilation").item(0);
        if (compilationNode != null && !(framework = this.getFrameworkAttribute(compilationNode)).isEmpty()) {
            return Collections.singletonList(framework);
        }
        NodeList targetFrameworkVersionNodeList = DocumentParser.getElementsByTag(file, "TargetFrameworkVersion");
        if (targetFrameworkVersionNodeList.getLength() > 0) {
            return Collections.singletonList(targetFrameworkVersionNodeList.item(0).getTextContent());
        }
        NodeList targetFrameworkNodeList = DocumentParser.getElementsByTag(file, "TargetFramework");
        if (targetFrameworkNodeList.getLength() > 0) {
            return Collections.singletonList(targetFrameworkNodeList.item(0).getTextContent());
        }
        NodeList targetFrameworksNodeList = DocumentParser.getElementsByTag(file, "TargetFrameworks");
        if (targetFrameworksNodeList.getLength() > 0 && (value = targetFrameworksNodeList.item(0).getTextContent()).contains(";")) {
            return Arrays.stream(value.split(";")).filter(v -> !v.trim().isEmpty()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String getFrameworkAttribute(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return "";
        }
        Node targetFrameworkNode = attributes.getNamedItem("targetFramework");
        if (targetFrameworkNode != null) {
            return targetFrameworkNode.getTextContent();
        }
        return "";
    }
}

