/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.api.spi;

import com.redhat.devtools.alizer.api.Language;
import com.redhat.devtools.alizer.api.spi.LanguageEnricherProvider;
import com.redhat.devtools.alizer.api.spi.framework.FrameworkDetectorProvider;
import com.redhat.devtools.alizer.api.spi.framework.go.GoFrameworkDetectorProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.regex.Pattern;

public class GoLanguageEnricherProviderImpl
extends LanguageEnricherProvider {
    @Override
    public LanguageEnricherProvider create() {
        return new GoLanguageEnricherProviderImpl();
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Arrays.asList("Go");
    }

    @Override
    public Language getEnrichedLanguage(Language language, List<File> files) throws IOException {
        Optional<File> goMod = files.stream().filter(file -> file.getName().equalsIgnoreCase("go.mod")).findFirst();
        if (goMod.isPresent()) {
            String goVersion = this.getGoVersion(goMod.get());
            if (!goVersion.isEmpty()) {
                language.setTools(Arrays.asList(goVersion));
            }
            language.setFrameworks(this.getFrameworks(goMod.get()));
        }
        return language;
    }

    private String getGoVersion(File goMod) throws IOException {
        Pattern goVersionLinePattern = Pattern.compile("^go\\s+");
        Optional<String> goVersionLine = Files.readAllLines(goMod.toPath()).stream().filter(line -> goVersionLinePattern.matcher((CharSequence)line).find()).findFirst();
        if (goVersionLine.isPresent()) {
            String[] version = goVersionLinePattern.split(goVersionLine.get());
            return version.length > 0 ? version[1] : "";
        }
        return "";
    }

    private List<String> getFrameworks(File file) throws IOException {
        ArrayList<String> frameworks = new ArrayList<String>();
        ServiceLoader<FrameworkDetectorProvider> loader = ServiceLoader.load(FrameworkDetectorProvider.class, GoLanguageEnricherProviderImpl.class.getClassLoader());
        for (FrameworkDetectorProvider provider : loader) {
            GoFrameworkDetectorProvider configProvider;
            if (!(provider instanceof GoFrameworkDetectorProvider) || !(configProvider = (GoFrameworkDetectorProvider)provider.create()).hasFramework(file)) continue;
            frameworks.addAll(configProvider.getFrameworks());
        }
        return frameworks;
    }
}

