/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonUiTestLibrary;

import com.intellij.remoterobot.RemoteRobot;
import com.redhat.devtools.intellij.commonUiTestLibrary.utils.GlobalUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class UITestRunner {
    private static final int defaultPort = 8580;
    private static RemoteRobot robot = null;
    private static Process ideProcess;

    public static RemoteRobot runIde(String ideaVersion, int port) {
        UITestRunner.makeSureAllTermsAndConditionsAreAccepted();
        String osName = System.getProperty("os.name").toLowerCase();
        ProcessBuilder pb = osName.contains("windows") ? new ProcessBuilder("powershell.exe", "Start-Process", ".\\gradlew.bat", "-ArgumentList", "\"runIdeForUiTests -PideaVersion=" + ideaVersion + "\"", "-WindowStyle", "hidden") : new ProcessBuilder("./gradlew", "runIdeForUiTests", "-PideaVersion=" + ideaVersion, "-Drobot-server.port=" + port);
        try {
            ideProcess = pb.start();
            GlobalUtils.waitUntilIntelliJStarts(port);
            robot = GlobalUtils.getRemoteRobotConnection(port);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        GlobalUtils.clearTheWorkspace();
        return robot;
    }

    public static RemoteRobot runIde(String ideaVersion) {
        return UITestRunner.runIde(ideaVersion, 8580);
    }

    public static void closeIde() {
        ideProcess.destroy();
    }

    public static RemoteRobot getRemoteRobotInstance() {
        return robot;
    }

    private static void makeSureAllTermsAndConditionsAreAccepted() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("linux")) {
            String prefsXmlSourceLocation = "prefs.xml";
            String prefsXmlDir = System.getProperty("user.home") + "/.java/.userPrefs/jetbrains/_!(!!cg\"p!(}!}@\"j!(k!|w\"w!'8!b!\"p!':!e@==";
            UITestRunner.createDirectoryHierarchy(prefsXmlDir);
            UITestRunner.copyFileFromJarResourceDir(prefsXmlSourceLocation, prefsXmlDir + "/prefs.xml");
            String acceptedSourceLocation = "accepted";
            String acceptedDir = System.getProperty("user.home") + "/.local/share/JetBrains/consentOptions";
            UITestRunner.createDirectoryHierarchy(acceptedDir);
            UITestRunner.copyFileFromJarResourceDir(acceptedSourceLocation, acceptedDir + "/accepted");
        } else if (osName.contains("os x")) {
            String plistSourceLocation = "com.apple.java.util.prefs.plist";
            String plistDir = System.getProperty("user.home") + "/Library/Preferences";
            UITestRunner.copyFileFromJarResourceDir(plistSourceLocation, plistDir + "/com.apple.java.util.prefs.plist");
            String acceptedSourceLocation = "accepted";
            String acceptedDir = System.getProperty("user.home") + "/Library/Application Support/JetBrains/consentOptions";
            UITestRunner.createDirectoryHierarchy(acceptedDir);
            UITestRunner.copyFileFromJarResourceDir(acceptedSourceLocation, acceptedDir + "/accepted");
            ProcessBuilder pb = new ProcessBuilder("killall", "cfprefsd");
            try {
                Process p = pb.start();
                p.waitFor();
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        } else if (osName.contains("windows")) {
            String acceptedSourceLocation = "accepted";
            String acceptedDir = System.getProperty("user.home") + "\\AppData\\Roaming\\JetBrains\\consentOptions";
            UITestRunner.createDirectoryHierarchy(acceptedDir);
            UITestRunner.copyFileFromJarResourceDir(acceptedSourceLocation, acceptedDir + "\\accepted");
            String registryPath = "HKCU:\\Software\\JavaSoft\\Prefs\\jetbrains\\privacy_policy";
            ProcessBuilder pb1 = new ProcessBuilder("powershell.exe", "New-Item", "-Path", registryPath, "-Force");
            ProcessBuilder pb2 = new ProcessBuilder("powershell.exe", "New-ItemProperty", "-Path", registryPath, "-Name", "accepted_version", "-Value", "\"2.1\"");
            try {
                Process p1 = pb1.start();
                p1.waitFor();
                Process p2 = pb2.start();
                p2.waitFor();
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static void createDirectoryHierarchy(String location) {
        Path path = Paths.get(location, new String[0]);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copyFileFromJarResourceDir(String sourceFileLocation, String destFileLocation) {
        InputStream resourceStream = UITestRunner.class.getClassLoader().getResourceAsStream(sourceFileLocation);
        try {
            byte[] buffer = new byte[resourceStream.available()];
            resourceStream.read(buffer);
            File targetFile = new File(destFileLocation);
            FileOutputStream outStream = new FileOutputStream(targetFile);
            ((OutputStream)outStream).write(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

