/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonUiTestLibrary.utils;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.fixtures.ComponentFixture;
import com.intellij.remoterobot.fixtures.dataExtractor.RemoteText;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.stepsProcessing.StepWorkerKt;
import com.intellij.remoterobot.utils.RepeatUtilsKt;
import com.intellij.remoterobot.utils.WaitForConditionTimeoutException;
import com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.dialogs.IdeFatalErrorsDialog;
import com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.dialogs.WelcomeFrameDialog;
import com.redhat.devtools.intellij.commonUiTestLibrary.utils.HelperUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import org.apache.commons.io.FileUtils;

public class GlobalUtils {
    private static RemoteRobot remoteRobot;

    public static void waitUntilIntelliJStarts(int port) {
        RepeatUtilsKt.waitFor((Duration)Duration.ofSeconds(600L), (Duration)Duration.ofSeconds(3L), (String)"The IntelliJ Idea did not start in 10 minutes.", () -> GlobalUtils.isIntelliJUIVisible(port));
    }

    private static boolean isIntelliJUIVisible(int port) {
        return GlobalUtils.isHostOnIpAndPortAccessible("127.0.0.1", port);
    }

    private static boolean isHostOnIpAndPortAccessible(String ip, int port) {
        InetSocketAddress sockaddr = new InetSocketAddress(ip, port);
        Socket socket = new Socket();
        try {
            socket.connect(sockaddr, 10000);
        }
        catch (IOException IOException2) {
            return false;
        }
        return true;
    }

    public static void clearTheWorkspace() {
        StepWorkerKt.step((String)"Delete all the projects in the workspace", () -> {
            int numberOfLinks = GlobalUtils.getNumberOfProjectLinks();
            for (int i = 0; i < numberOfLinks; ++i) {
                WelcomeFrameDialog welcomeFrameDialogFixture = (WelcomeFrameDialog)remoteRobot.find(WelcomeFrameDialog.class, Duration.ofSeconds(10L));
                ComponentFixture cf = (ComponentFixture)welcomeFrameDialogFixture.find(ComponentFixture.class, Locators.byXpath((String)"//div[@accessiblename='Recent Projects' and @class='MyList']"));
                cf.runJs("const horizontal_offset = component.getWidth()-22;\nrobot.click(component, new Point(horizontal_offset, 22), MouseButton.LEFT_BUTTON, 1);");
            }
            try {
                String pathToDirToMakeEmpty = System.getProperty("user.home") + File.separator + "IdeaProjects";
                boolean doesTheProjectDirExists = Files.exists(Paths.get(pathToDirToMakeEmpty, new String[0]), new LinkOption[0]);
                if (doesTheProjectDirExists) {
                    FileUtils.cleanDirectory((File)new File(pathToDirToMakeEmpty));
                } else {
                    Files.createDirectory(Paths.get(pathToDirToMakeEmpty, new String[0]), new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public static RemoteRobot getRemoteRobotConnection(int port) throws InterruptedException {
        remoteRobot = new RemoteRobot("http://127.0.0.1:" + port);
        for (int i = 0; i < 60; ++i) {
            try {
                remoteRobot.find(WelcomeFrameDialog.class);
                continue;
            }
            catch (Exception ex) {
                Thread.sleep(1000L);
            }
        }
        return remoteRobot;
    }

    private static int getNumberOfProjectLinks() {
        WelcomeFrameDialog welcomeFrameDialogFixture = (WelcomeFrameDialog)remoteRobot.find(WelcomeFrameDialog.class, Duration.ofSeconds(10L));
        try {
            ComponentFixture cf = (ComponentFixture)welcomeFrameDialogFixture.find(ComponentFixture.class, Locators.byXpath((String)"//div[@accessiblename='Recent Projects' and @class='MyList']"));
            int numberOfProjectsLinks = cf.findAllText().size() / 2;
            return numberOfProjectsLinks;
        }
        catch (WaitForConditionTimeoutException e) {
            return 0;
        }
    }

    public static void checkForExceptions() {
        StepWorkerKt.step((String)"Check for exceptions and other errors", () -> {
            try {
                WelcomeFrameDialog welcomeFrameDialogFixture = (WelcomeFrameDialog)remoteRobot.find(WelcomeFrameDialog.class, Duration.ofSeconds(10L));
                welcomeFrameDialogFixture.ideErrorsIcon().click();
            }
            catch (WaitForConditionTimeoutException e) {
                e.printStackTrace();
                return;
            }
            IdeFatalErrorsDialog ideFatalErrorsDialogFixture = (IdeFatalErrorsDialog)remoteRobot.find(IdeFatalErrorsDialog.class, Duration.ofSeconds(10L));
            String exceptionNumberLabel = ((RemoteText)ideFatalErrorsDialogFixture.numberOfExcetionsJBLabel().findAllText().get(0)).getText();
            int numberOfExceptions = Integer.parseInt(exceptionNumberLabel.substring(5));
            for (int i = 0; i < numberOfExceptions; ++i) {
                String exceptionStackTrace = HelperUtils.listOfRemoteTextToString(ideFatalErrorsDialogFixture.exceptionDescriptionJTextArea().findAllText());
                if (i + 1 >= numberOfExceptions) continue;
                ideFatalErrorsDialogFixture.nextExceptionButton().click();
            }
            ideFatalErrorsDialogFixture.button("Clear all").click();
        });
    }
}

