/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonUiTestLibrary;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.stepsProcessing.StepLogger;
import com.intellij.remoterobot.stepsProcessing.StepProcessor;
import com.intellij.remoterobot.stepsProcessing.StepWorker;
import com.intellij.remoterobot.stepsProcessing.StepWorkerKt;
import com.intellij.remoterobot.utils.RepeatUtilsKt;
import com.intellij.remoterobot.utils.WaitForConditionTimeoutException;
import com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.dialogs.FlatWelcomeFrame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;

public class UITestRunner {
    private static final int defaultPort = 8580;
    private static RemoteRobot remoteRobot = null;
    private static Process ideProcess;
    private static IdeaVersion ideaVersion;

    public static RemoteRobot runIde(IdeaVersion ideaVersion, int port) {
        StepWorker.registerProcessor((StepProcessor)new StepLogger());
        return (RemoteRobot)StepWorkerKt.step((String)("Start IntelliJ Idea ('" + ideaVersion.toString() + "') listening on port " + port), () -> {
            UITestRunner.ideaVersion = ideaVersion;
            UITestRunner.makeSureAllTermsAndConditionsAreAccepted();
            String osName = System.getProperty("os.name").toLowerCase();
            String fileExtension = osName.contains("windows") ? ".bat" : "";
            ProcessBuilder pb = new ProcessBuilder("." + File.separator + "gradlew" + fileExtension, "runIdeForUiTests", "-PideaVersion=" + ideaVersion.toString(), "-Drobot-server.port=" + port);
            try {
                ideProcess = pb.start();
                UITestRunner.waitUntilIntelliJStarts(port);
                remoteRobot = UITestRunner.getRemoteRobotConnection(port);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
            ((FlatWelcomeFrame)remoteRobot.find(FlatWelcomeFrame.class, Duration.ofSeconds(10L))).clearWorkspace();
            return remoteRobot;
        });
    }

    public static RemoteRobot runIde(IdeaVersion ideaVersion) {
        return UITestRunner.runIde(ideaVersion, 8580);
    }

    public static void closeIde() {
        StepWorkerKt.step((String)"Close IntelliJ Idea", () -> {
            if (remoteRobot.isWin()) {
                ((FlatWelcomeFrame)remoteRobot.find(FlatWelcomeFrame.class, Duration.ofSeconds(10L))).runJs("const horizontal_offset = component.getWidth() - 24;\nrobot.click(component, new Point(horizontal_offset, 14), MouseButton.LEFT_BUTTON, 2);");
            } else {
                ideProcess.destroy();
            }
        });
    }

    public static IdeaVersion getIdeaVersion() {
        return ideaVersion;
    }

    public static RemoteRobot getRemoteRobot() {
        return remoteRobot;
    }

    public static RemoteRobot getRemoteRobotConnection(int port) throws InterruptedException {
        return (RemoteRobot)StepWorkerKt.step((String)("Create an instance of the RemoteRobot listening on port " + port), () -> {
            RemoteRobot remoteRobot = new RemoteRobot("http://127.0.0.1:" + port);
            for (int i = 0; i < 60; ++i) {
                try {
                    remoteRobot.find(FlatWelcomeFrame.class);
                    continue;
                }
                catch (WaitForConditionTimeoutException e) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            return remoteRobot;
        });
    }

    private static void makeSureAllTermsAndConditionsAreAccepted() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("linux")) {
            StepWorkerKt.step((String)"Copy the 'prefs.xml' file to the appropriate location", () -> {
                String prefsXmlSourceLocation = "prefs.xml";
                String prefsXmlDir = System.getProperty("user.home") + "/.java/.userPrefs/jetbrains/_!(!!cg\"p!(}!}@\"j!(k!|w\"w!'8!b!\"p!':!e@==";
                UITestRunner.createDirectoryHierarchy(prefsXmlDir);
                UITestRunner.copyFileFromJarResourceDir(prefsXmlSourceLocation, prefsXmlDir + "/prefs.xml");
            });
            StepWorkerKt.step((String)"Copy the 'accepted' file to the appropriate location", () -> {
                String acceptedSourceLocation = "accepted";
                String acceptedDir = System.getProperty("user.home") + "/.local/share/JetBrains/consentOptions";
                UITestRunner.createDirectoryHierarchy(acceptedDir);
                UITestRunner.copyFileFromJarResourceDir(acceptedSourceLocation, acceptedDir + "/accepted");
            });
        } else if (osName.contains("os x")) {
            StepWorkerKt.step((String)"Copy the 'com.apple.java.util.prefs.plist' file to the appropriate location", () -> {
                String plistSourceLocation = "com.apple.java.util.prefs.plist";
                String plistDir = System.getProperty("user.home") + "/Library/Preferences";
                UITestRunner.copyFileFromJarResourceDir(plistSourceLocation, plistDir + "/com.apple.java.util.prefs.plist");
            });
            StepWorkerKt.step((String)"Copy the 'accepted' file to the appropriate location", () -> {
                String acceptedSourceLocation = "accepted";
                String acceptedDir = System.getProperty("user.home") + "/Library/Application Support/JetBrains/consentOptions";
                UITestRunner.createDirectoryHierarchy(acceptedDir);
                UITestRunner.copyFileFromJarResourceDir(acceptedSourceLocation, acceptedDir + "/accepted");
                ProcessBuilder pb = new ProcessBuilder("killall", "cfprefsd");
                try {
                    Process p = pb.start();
                    p.waitFor();
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                }
            });
        } else if (osName.contains("windows")) {
            StepWorkerKt.step((String)"Copy the 'accepted' file to the appropriate location", () -> {
                String acceptedSourceLocation = "accepted";
                String acceptedDir = System.getProperty("user.home") + "\\AppData\\Roaming\\JetBrains\\consentOptions";
                UITestRunner.createDirectoryHierarchy(acceptedDir);
                UITestRunner.copyFileFromJarResourceDir(acceptedSourceLocation, acceptedDir + "\\accepted");
            });
            StepWorkerKt.step((String)"Create appropriate registry entries", () -> {
                String registryPath = "HKCU:\\Software\\JavaSoft\\Prefs\\jetbrains\\privacy_policy";
                ProcessBuilder pb1 = new ProcessBuilder("powershell.exe", "New-Item", "-Path", registryPath, "-Force");
                ProcessBuilder pb2 = new ProcessBuilder("powershell.exe", "New-ItemProperty", "-Path", registryPath, "-Name", "accepted_version", "-Value", "'2.1'");
                try {
                    Process p1 = pb1.start();
                    p1.waitFor();
                    Process p2 = pb2.start();
                    p2.waitFor();
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private static void waitUntilIntelliJStarts(int port) {
        RepeatUtilsKt.waitFor((Duration)Duration.ofSeconds(600L), (Duration)Duration.ofSeconds(3L), (String)"The IntelliJ Idea did not start in 10 minutes.", () -> UITestRunner.isIntelliJUIVisible(port));
    }

    private static boolean isIntelliJUIVisible(int port) {
        return UITestRunner.isHostOnIpAndPortAccessible("127.0.0.1", port);
    }

    private static boolean isHostOnIpAndPortAccessible(String ip, int port) {
        InetSocketAddress sockaddr = new InetSocketAddress(ip, port);
        Socket socket = new Socket();
        try {
            socket.connect(sockaddr, 10000);
        }
        catch (IOException IOException2) {
            return false;
        }
        return true;
    }

    private static void createDirectoryHierarchy(String location) {
        Path path = Paths.get(location, new String[0]);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copyFileFromJarResourceDir(String sourceFileLocation, String destFileLocation) {
        InputStream resourceStream = UITestRunner.class.getClassLoader().getResourceAsStream(sourceFileLocation);
        try {
            byte[] buffer = new byte[resourceStream.available()];
            resourceStream.read(buffer);
            File targetFile = new File(destFileLocation);
            FileOutputStream outStream = new FileOutputStream(targetFile);
            ((OutputStream)outStream).write(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum IdeaVersion {
        V_2020_2("IC-2020.2"),
        V_2020_3("IC-2020.3");

        private final String ideaVersionStringRepresentation;

        private IdeaVersion(String ideaVersionStringRepresentation) {
            this.ideaVersionStringRepresentation = ideaVersionStringRepresentation;
        }

        public String toString() {
            return this.ideaVersionStringRepresentation;
        }

        public int toInt() {
            String ideaVersion = this.ideaVersionStringRepresentation.substring(3).replace(".", "");
            return Integer.parseInt(ideaVersion);
        }
    }
}

