/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.dialogs.project.pages;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.ComboBoxFixture;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.fixtures.JListFixture;
import com.intellij.remoterobot.fixtures.JPopupMenuFixture;
import com.intellij.remoterobot.fixtures.dataExtractor.RemoteText;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.stepsProcessing.StepWorkerKt;
import com.intellij.remoterobot.utils.RepeatUtilsKt;
import com.redhat.devtools.intellij.commonUiTestLibrary.utils.textTranformation.TextUtils;
import java.time.Duration;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="MyDialog type", xpath="//div[@class='DialogRootPane']")
@FixtureName(name="New Project Dialog")
public class NewProjectFirstPage
extends CommonContainerFixture {
    private static RemoteRobot remoteRobot;
    private int projectSdkItemsCount = -1;

    public NewProjectFirstPage(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
        NewProjectFirstPage.remoteRobot = remoteRobot;
    }

    public void selectNewProjectType(String projectType) {
        ((JListFixture)this.jLists(JListFixture.Companion.byType()).get(0)).findText(projectType).click();
    }

    public void setProjectSdkIfAvailable(String targetSdkName) {
        StepWorkerKt.step((String)("Select the '" + targetSdkName + "' as new project SDK"), () -> {
            ComboBoxFixture projectJdkComboBox = this.comboBox(Locators.byXpath((String)"//div[@accessiblename='Project SDK:' and @class='JPanel']/div[@class='JdkComboBox']"), Duration.ofSeconds(10L));
            String currentlySelectedProjectSdk = TextUtils.listOfRemoteTextToString(projectJdkComboBox.findAllText());
            if (currentlySelectedProjectSdk.contains(targetSdkName)) {
                return;
            }
            projectJdkComboBox.click();
            CommonContainerFixture parentFixture = (CommonContainerFixture)RepeatUtilsKt.waitFor((Duration)Duration.ofSeconds(20L), (Duration)Duration.ofSeconds(2L), (String)"The project JDK list did not load all items in 20 seconds.", () -> this.didProjectSdkListLoadAllItems());
            JPopupMenuFixture projectSdkList = (JPopupMenuFixture)parentFixture.jPopupMenus(Locators.byXpath((String)"//div[@class='HeavyWeightWindow']")).get(0);
            List sdkItems = projectSdkList.findAllText();
            for (RemoteText sdkItem : sdkItems) {
                if (!sdkItem.getText().contains(targetSdkName)) continue;
                try {
                    sdkItem.click();
                }
                catch (Exception e) {
                    break;
                }
            }
        });
    }

    private Pair<Boolean, CommonContainerFixture> didProjectSdkListLoadAllItems() {
        return (Pair)StepWorkerKt.step((String)"Test whether the 'Project SDK' list has loaded all items", () -> {
            CommonContainerFixture parentFixture = (CommonContainerFixture)remoteRobot.find(CommonContainerFixture.class, Locators.byXpath((String)"//div[@class='MyDialog']"));
            JPopupMenuFixture projectSdkList = (JPopupMenuFixture)parentFixture.jPopupMenus(Locators.byXpath((String)"//div[@class='HeavyWeightWindow']")).get(0);
            List sdkItems = projectSdkList.findAllText();
            int currentSdkItemsCount = sdkItems.size();
            if (this.projectSdkItemsCount == -1) {
                this.projectSdkItemsCount = currentSdkItemsCount;
                return new Pair((Object)false, (Object)parentFixture);
            }
            if (this.projectSdkItemsCount != currentSdkItemsCount) {
                this.projectSdkItemsCount = currentSdkItemsCount;
                return new Pair((Object)false, (Object)parentFixture);
            }
            return new Pair((Object)true, (Object)parentFixture);
        });
    }
}

