/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.mainIdeWindow.ideStatusBar;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.ComponentFixture;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.utils.RepeatUtilsKt;
import com.intellij.remoterobot.utils.WaitForConditionTimeoutException;
import java.time.Duration;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="IdeStatusBarImpl type", xpath="//div[@class='IdeStatusBarImpl']")
@FixtureName(name="Ide Status Bar")
public class IdeStatusBar
extends CommonContainerFixture {
    private RemoteRobot remoteRobot;

    public IdeStatusBar(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
        this.remoteRobot = remoteRobot;
    }

    public ComponentFixture inlineProgressPanel() {
        return (ComponentFixture)this.find(ComponentFixture.class, Locators.byXpath((String)"//div[@class='InlineProgressPanel']"));
    }

    public void waitUntilProjectImportIsComplete() {
        RepeatUtilsKt.waitFor((Duration)Duration.ofSeconds(300L), (Duration)Duration.ofSeconds(5L), (String)"The project import did not finish in 5 minutes.", () -> this.didProjectImportFinish());
    }

    public void waitUntilAllBgTasksFinish() {
        RepeatUtilsKt.waitFor((Duration)Duration.ofSeconds(300L), (Duration)Duration.ofSeconds(10L), (String)"The background tasks did not finish in 5 minutes.", () -> this.didAllBgTasksFinish());
    }

    private boolean didProjectImportFinish() {
        try {
            this.find(ComponentFixture.class, Locators.byXpath((String)"//div[@class='EngravedLabel']"), Duration.ofSeconds(10L));
        }
        catch (WaitForConditionTimeoutException e) {
            return true;
        }
        return false;
    }

    private boolean didAllBgTasksFinish() {
        for (int i = 0; i < 5; ++i) {
            IdeStatusBar ideStatusBar = (IdeStatusBar)this.remoteRobot.find(IdeStatusBar.class);
            List inlineProgressPanelContent = ideStatusBar.inlineProgressPanel().findAllText();
            if (!inlineProgressPanelContent.isEmpty()) {
                return false;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

