/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.mainIdeWindow.toolWindowsPane;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.Fixture;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.fixtures.JButtonFixture;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.utils.RepeatUtilsKt;
import com.intellij.remoterobot.utils.WaitForConditionTimeoutException;
import com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.mainIdeWindow.toolWindowsPane.ProjectExplorer;
import com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.mainIdeWindow.toolWindowsPane.buildToolPane.GradleBuildToolPane;
import com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.mainIdeWindow.toolWindowsPane.buildToolPane.MavenBuildToolPane;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="ToolWindowsPane type", xpath="//div[@class='ToolWindowsPane']")
@FixtureName(name="Tool Windows Pane")
public class ToolWindowsPane
extends CommonContainerFixture {
    private RemoteRobot remoteRobot;

    public ToolWindowsPane(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
        this.remoteRobot = remoteRobot;
    }

    public ProjectExplorer openProjectExplorer() {
        return this.togglePane("Project", ProjectExplorer.class, true);
    }

    public void closeProjectExplorer() {
        this.togglePane("Project", ProjectExplorer.class, false);
    }

    public MavenBuildToolPane openMavenBuildToolPane() {
        return this.togglePane("Maven", MavenBuildToolPane.class, true);
    }

    public void closeMavenBuildToolPane() {
        this.togglePane("Maven", MavenBuildToolPane.class, false);
    }

    public GradleBuildToolPane openGradleBuildToolPane() {
        return this.togglePane("Gradle", GradleBuildToolPane.class, true);
    }

    public void closeGradleBuildToolPane() {
        this.togglePane("Gradle", GradleBuildToolPane.class, false);
    }

    public JButtonFixture stripeButton(String label, boolean isPaneOpened) {
        if (isPaneOpened) {
            if (label.equals("Maven") || label.equals("Gradle")) {
                return this.button(Locators.byXpath((String)("//div[@disabledicon='toolWindow" + label + ".svg']")), Duration.ofSeconds(2L));
            }
            if (label.equals("Project")) {
                return this.button(Locators.byXpath((String)"//div[@tooltiptext='Project']"), Duration.ofSeconds(2L));
            }
        }
        return this.button(Locators.byXpath((String)("//div[@text='" + label + "']")), Duration.ofSeconds(2L));
    }

    private <T extends Fixture> T togglePane(String label, Class<T> fixtureClass, boolean openPane) {
        if (!this.isPaneOpened(fixtureClass) && openPane) {
            this.clickOnStripeButton(label, false);
            return (T)this.find(fixtureClass, Duration.ofSeconds(10L));
        }
        if (this.isPaneOpened(fixtureClass) && !openPane) {
            this.clickOnStripeButton(label, true);
        }
        return null;
    }

    private boolean isPaneOpened(Class fixtureClass) {
        ToolWindowsPane toolWindowsPane = (ToolWindowsPane)this.remoteRobot.find(ToolWindowsPane.class, Duration.ofSeconds(10L));
        try {
            toolWindowsPane.find(fixtureClass, Duration.ofSeconds(10L));
            return true;
        }
        catch (WaitForConditionTimeoutException e) {
            return false;
        }
    }

    private void clickOnStripeButton(String label, boolean isPaneOpened) {
        RepeatUtilsKt.waitFor((Duration)Duration.ofSeconds(30L), (Duration)Duration.ofSeconds(2L), (String)("The '" + label + "' stripe button is not available."), () -> this.isStripeButtonAvailable(label, isPaneOpened));
        ((ToolWindowsPane)this.remoteRobot.find(ToolWindowsPane.class, Duration.ofSeconds(10L))).stripeButton(label, isPaneOpened).click();
    }

    private boolean isStripeButtonAvailable(String label, boolean isPaneOpened) {
        try {
            ((ToolWindowsPane)this.remoteRobot.find(ToolWindowsPane.class, Duration.ofSeconds(10L))).stripeButton(label, isPaneOpened);
        }
        catch (WaitForConditionTimeoutException e) {
            return false;
        }
        return true;
    }
}

