/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.mainIdeWindow.toolWindowsPane.buildToolPane;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.fixtures.JTreeFixture;
import com.intellij.remoterobot.fixtures.dataExtractor.RemoteText;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.utils.RepeatUtilsKt;
import com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.mainIdeWindow.toolWindowsPane.BuildView;
import com.redhat.devtools.intellij.commonUiTestLibrary.fixtures.mainIdeWindow.toolWindowsPane.ToolWindowsPane;
import com.redhat.devtools.intellij.commonUiTestLibrary.utils.textTranformation.TextUtils;
import java.time.Duration;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="ToolWindowsPane type", xpath="//div[@accessiblename='Gradle Tool Window']")
@FixtureName(name="Tool Windows Pane")
public class GradleBuildToolPane
extends CommonContainerFixture {
    private RemoteRobot remoteRobot;

    public GradleBuildToolPane(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
        this.remoteRobot = remoteRobot;
    }

    public void reloadAllGradleProjects() {
        this.actionButton(Locators.byXpath((String)"//div[@myicon='refresh.svg']"), Duration.ofSeconds(2L)).click();
    }

    public void expandAll() {
        this.actionButton(Locators.byXpath((String)"//div[contains(@myvisibleactions, 'IDE')]//div[@myicon='expandall.svg']"), Duration.ofSeconds(2L)).click();
    }

    public void collapseAll() {
        this.actionButton(Locators.byXpath((String)"//div[contains(@myvisibleactions, 'IDE')]//div[@myicon='collapseall.svg']"), Duration.ofSeconds(2L)).click();
    }

    public void buildProject() {
        RepeatUtilsKt.waitFor((Duration)Duration.ofSeconds(30L), (Duration)Duration.ofSeconds(2L), (String)"The Gradle tasks tree did not appear in 30 seconds.", () -> this.isGradleTreeVisible());
        this.gradleTaskTree().expandAll();
        ((RemoteText)this.gradleTaskTree().findAllText("build").get(1)).doubleClick();
        ((BuildView)((ToolWindowsPane)this.remoteRobot.find(ToolWindowsPane.class)).find(BuildView.class)).waitUntilBuildHasFinished();
    }

    public JTreeFixture gradleTaskTree() {
        return (JTreeFixture)this.find(JTreeFixture.class, JTreeFixture.Companion.byType(), Duration.ofSeconds(10L));
    }

    private boolean isGradleTreeVisible() {
        String treeContent = TextUtils.listOfRemoteTextToString(this.gradleTaskTree().findAllText());
        return !treeContent.toLowerCase(Locale.ROOT).contains("nothing") && !treeContent.equals("");
    }
}

